/**
 * LICENSE KURULUM SCRIPT'İ
 * 
 * Bu script'i müşteriye teslim ederken çalıştıracaksın.
 * Domain'i database'e şifreli olarak kaydeder.
 * 
 * KULLANIM:
 * npx tsx scripts/setup-license.ts iddaasohbet.com
 */

import { PrismaClient } from '@prisma/client'
import { encryptDomain, createLicenseHash } from '../lib/license'

const prisma = new PrismaClient()

async function setupLicense() {
  const domain = process.argv[2]
  
  if (!domain) {
    console.error('❌ Domain belirtilmedi!')
    console.log('📝 Kullanım: npx tsx scripts/setup-license.ts iddaasohbet.com')
    process.exit(1)
  }

  console.log('\n🔐 LICENSE KURULUM BAŞLIYOR...\n')
  console.log(`📍 Domain: ${domain}`)
  
  try {
    // Domain'i şifrele
    const encryptedDomain = encryptDomain(domain)
    console.log('✅ Domain şifrelendi')
    
    // Hash oluştur - Sabit timestamp kullan (domain bazlı)
    const fixedTimestamp = 1730415600000 // 2024-11-01 fixed
    const licenseHash = createLicenseHash(domain, fixedTimestamp)
    console.log('✅ License hash oluşturuldu')
    
    // Expire date (1 yıl sonra)
    const expiresAt = new Date()
    expiresAt.setFullYear(expiresAt.getFullYear() + 1)
    
    // Metadata (şifreli)
    const metadata = encryptDomain(JSON.stringify({
      customer: 'İddaaSohbet',
      installedBy: 'Cihatsoft',
      version: '1.0.0',
      timestamp: fixedTimestamp
    }))
    
    // Mevcut license varsa sil
    await prisma.systemLicense.deleteMany({})
    console.log('🗑️  Eski license kayıtları temizlendi')
    
    // Yeni license oluştur
    const license = await prisma.systemLicense.create({
      data: {
        encryptedDomain,
        licenseHash,
        active: true,
        expiresAt,
        metadata
      }
    })
    
    console.log('\n✅ LICENSE BAŞARIYLA KURULDU!\n')
    console.log('📋 License Detayları:')
    console.log(`   ID: ${license.id}`)
    console.log(`   Domain: ${domain} (şifreli)`)
    console.log(`   Durum: Aktif`)
    console.log(`   Son Kullanma: ${expiresAt.toLocaleDateString('tr-TR')}`)
    console.log('\n🎉 Sistem hazır! Artık sadece bu domain\'de çalışacak.\n')
    
  } catch (error) {
    console.error('\n❌ HATA:', error)
    process.exit(1)
  } finally {
    await prisma.$disconnect()
  }
}

setupLicense()
