import { PrismaClient } from '@prisma/client'

const prisma = new PrismaClient()

async function main() {
  // Tüm blogları yayınla
  const result = await prisma.blogPost.updateMany({
    where: {
      published: false
    },
    data: {
      published: true,
      publishedAt: new Date()
    }
  })

  console.log(`✅ ${result.count} blog yazısı yayınlandı!`)
  
  // Tüm blogları göster
  const blogs = await prisma.blogPost.findMany()
  console.log('\n📚 Tüm Blog Yazıları:')
  blogs.forEach(blog => {
    console.log(`- ${blog.title} (${blog.published ? '✅ Yayınlı' : '❌ Taslak'})`)
  })
}

main()
  .catch(console.error)
  .finally(() => prisma.$disconnect())



