'use client'

import { useEffect, useState } from 'react'
import { Trophy } from 'lucide-react'

export default function SplashScreen() {
  const [isVisible, setIsVisible] = useState(true)
  const [progress, setProgress] = useState(0)
  const [loadingStage, setLoadingStage] = useState('Başlatılıyor')

  useEffect(() => {
    const stages = [
      { text: 'Başlatılıyor', duration: 500 },
      { text: 'Bağlantı kuruluyor', duration: 400 },
      { text: 'Veriler yükleniyor', duration: 600 },
      { text: 'Hazırlanıyor', duration: 500 }
    ]

    let currentProgress = 0
    let stageIndex = 0

    const progressInterval = setInterval(() => {
      currentProgress += Math.random() * 8 + 2
      
      if (currentProgress >= 100) {
        currentProgress = 100
        clearInterval(progressInterval)
      }
      
      setProgress(Math.min(currentProgress, 100))

      // Stage değiştir
      const totalDuration = stages.reduce((sum, s) => sum + s.duration, 0)
      const elapsed = (currentProgress / 100) * totalDuration
      let cumulativeDuration = 0
      
      for (let i = 0; i < stages.length; i++) {
        cumulativeDuration += stages[i].duration
        if (elapsed < cumulativeDuration) {
          if (stageIndex !== i) {
            stageIndex = i
            setLoadingStage(stages[i].text)
          }
          break
        }
      }
    }, 50)

    const timer = setTimeout(() => {
      setIsVisible(false)
    }, 2200)

    return () => {
      clearInterval(progressInterval)
      clearTimeout(timer)
    }
  }, [])

  if (!isVisible) return null

  return (
    <div className={`fixed inset-0 z-[9999] flex items-center justify-center overflow-hidden bg-black transition-all duration-700 ${isVisible ? 'opacity-100' : 'opacity-0 pointer-events-none'}`}>
      {/* Subtle Background */}
      <div className="absolute inset-0 bg-gradient-to-b from-gray-950 via-black to-gray-950"></div>
      
      {/* Minimal Grid */}
      <div className="absolute inset-0 opacity-[0.02]" style={{
        backgroundImage: 'linear-gradient(rgba(34, 197, 94, 0.1) 1px, transparent 1px), linear-gradient(90deg, rgba(34, 197, 94, 0.1) 1px, transparent 1px)',
        backgroundSize: '50px 50px'
      }}></div>

      {/* Subtle Glow */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-green-500/5 rounded-full blur-[120px]"></div>
      </div>

      {/* Main Content */}
      <div className="relative z-10 flex flex-col items-center space-y-12">
        {/* Logo Container */}
        <div className="relative">
          {/* Clean Logo */}
          <div className="relative flex items-center justify-center w-32 h-32">
            <Trophy className="h-20 w-20 text-green-500" strokeWidth={1.5} />
            
            {/* Rotating Ring */}
            <svg className="absolute inset-0 w-32 h-32 -rotate-90 animate-spin-corporate" viewBox="0 0 128 128">
              <circle
                cx="64"
                cy="64"
                r="60"
                fill="none"
                stroke="url(#gradient)"
                strokeWidth="2"
                strokeDasharray="377"
                strokeDashoffset="94"
                strokeLinecap="round"
                className="opacity-80"
              />
              <defs>
                <linearGradient id="gradient" x1="0%" y1="0%" x2="100%" y2="100%">
                  <stop offset="0%" stopColor="#22c55e" />
                  <stop offset="50%" stopColor="#10b981" />
                  <stop offset="100%" stopColor="#facc15" />
                </linearGradient>
              </defs>
            </svg>
          </div>
        </div>

        {/* Brand */}
        <div className="text-center space-y-2">
          <div className="flex items-center justify-center gap-2">
            <h1 className="text-4xl font-bold text-white">İddaa</h1>
            <h1 className="text-4xl font-bold text-green-500">Sohbet</h1>
          </div>
          <p className="text-sm text-gray-400 font-medium tracking-wide">Premium Kupon Paylaşım Platformu</p>
        </div>

        {/* Progress Section */}
        <div className="w-96 max-w-[90vw] space-y-3">
          {/* Progress Bar */}
          <div className="relative h-1 bg-gray-800/50 rounded-full overflow-hidden">
            <div 
              className="absolute inset-y-0 left-0 bg-gradient-to-r from-green-500 to-emerald-500 rounded-full transition-all duration-300 ease-out"
              style={{ width: `${progress}%` }}
            >
              <div className="absolute inset-0 bg-gradient-to-r from-transparent via-white/20 to-transparent animate-shimmer"></div>
            </div>
          </div>

          {/* Status Text */}
          <div className="flex items-center justify-between text-sm">
            <span className="text-gray-400 font-medium">{loadingStage}</span>
            <span className="text-green-500 font-semibold tabular-nums">{Math.floor(progress)}%</span>
          </div>
        </div>

        {/* Minimal Loading Indicator */}
        <div className="flex items-center space-x-1.5">
          {[0, 1, 2].map((i) => (
            <div
              key={i}
              className="w-2 h-2 bg-green-500/60 rounded-full animate-pulse-wave"
              style={{ animationDelay: `${i * 0.2}s` }}
            />
          ))}
        </div>
      </div>

      {/* Footer Badge */}
      <div className="absolute bottom-8 left-1/2 -translate-x-1/2">
        <div className="flex items-center space-x-2 text-xs text-gray-600">
          <div className="w-1.5 h-1.5 bg-green-500 rounded-full"></div>
          <span className="font-medium tracking-wider">POWERED BY DİJİTAL WEBSİTE</span>
        </div>
      </div>


      <style jsx>{`
        @keyframes spin-corporate {
          0% { transform: rotate(-90deg); }
          100% { transform: rotate(270deg); }
        }

        @keyframes shimmer {
          0% { transform: translateX(-100%); }
          100% { transform: translateX(200%); }
        }

        @keyframes pulse-wave {
          0%, 100% { 
            opacity: 0.3;
            transform: scale(0.8);
          }
          50% { 
            opacity: 1;
            transform: scale(1.2);
          }
        }

        .animate-spin-corporate {
          animation: spin-corporate 1.5s cubic-bezier(0.4, 0, 0.2, 1) infinite;
        }

        .animate-shimmer {
          animation: shimmer 2s ease-in-out infinite;
        }

        .animate-pulse-wave {
          animation: pulse-wave 1.5s ease-in-out infinite;
        }
      `}</style>
    </div>
  )
}

