import { ArrowRight } from 'lucide-react'

export default function SEOContent() {
  return (
    <section className="container mx-auto px-4 py-16 space-y-12">
      {/* SEO Optimized Content */}
      <article className="glass-dark border-white/10 p-12 rounded-2xl">
        <h2 className="text-4xl font-bold gradient-text mb-6 text-center">
          Profesyonel İddaa Tahminleri ve Banko Kupon Önerileri
        </h2>
        
        <div className="prose prose-invert prose-lg max-w-none space-y-6">
          <div className="grid md:grid-cols-2 gap-8">
            <div>
              <h3 className="text-2xl font-bold text-green-400 mb-4">Bugünkü İddaa Tahminleri</h3>
              <p className="text-foreground/80 leading-relaxed">
                Platformumuzda her gün güncellenen <strong>bugünkü iddaa maç tahminleri</strong> ve 
                <strong> banko iddaa tahminleri</strong> bulabilirsiniz. Profesyonel analistlerimiz 
                tarafından hazırlanan <strong>analizli iddaa tahminleri</strong> ile kazanma şansınızı artırın.
              </p>
            </div>

            <div>
              <h3 className="text-2xl font-bold text-yellow-400 mb-4">Haftalık Kupon Önerileri</h3>
              <p className="text-foreground/80 leading-relaxed">
                <strong>Haftalık iddaa kupon önerileri</strong> ve <strong>yüksek oranlı iddaa tahminleri</strong> 
                platformumuzun en popüler bölümlerindendir. Güncel iddaa tahminleri ile 
                <strong> banko kupon iddaa</strong> stratejileri oluşturun.
              </p>
            </div>
          </div>

          <div className="grid md:grid-cols-2 gap-8 mt-8">
            <div>
              <h3 className="text-2xl font-bold text-emerald-400 mb-4">Süper Lig Tahmin ve Analiz</h3>
              <p className="text-foreground/80 leading-relaxed">
                <strong>Süper Lig iddaa tahmini yorumları</strong> ve detaylı maç analizleri. 
                <strong>İddaa oran tahminleri</strong> ve <strong>maç sonucu tahminleri</strong> ile 
                en doğru kararları verin. Üst alt tahmin ve karşılıklı gol tahminleri de mevcut.
              </p>
            </div>

            <div>
              <h3 className="text-2xl font-bold text-blue-400 mb-4">Ücretsiz Bahis Tahmin Sitesi</h3>
              <p className="text-foreground/80 leading-relaxed">
                Türkiye'nin önde gelen <strong>ücretsiz iddaa tahminleri</strong> ve 
                <strong> bahis tahmini sitesi</strong>. <strong>İddaa tahmin sitesi</strong> olarak 
                <strong> iddaa yorumları</strong> ve <strong>iddaa analizleri</strong> sunuyoruz.
              </p>
            </div>
          </div>

          <div className="mt-8 p-6 bg-gradient-to-r from-green-500/10 to-yellow-400/10 rounded-xl border border-green-500/20">
            <h3 className="text-2xl font-bold text-center mb-4">Neden İddaaSohbet?</h3>
            <ul className="grid md:grid-cols-2 gap-4 text-foreground/80">
              <li className="flex items-start space-x-2">
                <span className="text-green-400 text-xl">✓</span>
                <span><strong>Güncel iddaa tahminleri</strong> - Her gün yeni tahminler</span>
              </li>
              <li className="flex items-start space-x-2">
                <span className="text-green-400 text-xl">✓</span>
                <span><strong>Banko iddaa tahmini</strong> - Güvenilir banko seçenekler</span>
              </li>
              <li className="flex items-start space-x-2">
                <span className="text-green-400 text-xl">✓</span>
                <span><strong>Analizli tahminler</strong> - Detaylı maç analizleri</span>
              </li>
              <li className="flex items-start space-x-2">
                <span className="text-green-400 text-xl">✓</span>
                <span><strong>Yüksek oranlı kuponlar</strong> - Kazançlı fırsatlar</span>
              </li>
              <li className="flex items-start space-x-2">
                <span className="text-green-400 text-xl">✓</span>
                <span><strong>Süper Lig tahminleri</strong> - Türk futbolu analizi</span>
              </li>
              <li className="flex items-start space-x-2">
                <span className="text-green-400 text-xl">✓</span>
                <span><strong>Ücretsiz erişim</strong> - Tüm özellikler bedava</span>
              </li>
            </ul>
          </div>
        </div>
      </article>

      {/* SEO FAQ Section - Premium Design */}
      <article className="relative glass-dark border border-white/10 p-12 rounded-3xl overflow-hidden">
        {/* Background Effects */}
        <div className="absolute inset-0 bg-gradient-to-br from-green-500/5 via-transparent to-yellow-500/5"></div>
        <div className="absolute top-0 right-0 w-96 h-96 bg-green-500/10 rounded-full blur-[120px]"></div>
        
        {/* Header */}
        <div className="relative z-10 text-center mb-12">
          <div className="inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-gradient-to-br from-green-500/20 to-yellow-400/20 border border-green-500/30 mb-6">
            <span className="text-3xl">❓</span>
          </div>
          <h2 className="text-5xl font-black gradient-text mb-4">
            Sıkça Sorulan Sorular
          </h2>
          <p className="text-xl text-foreground/70">İddaa Tahminleri Hakkında Merak Edilenler</p>
        </div>
        
        <div className="relative z-10 grid md:grid-cols-2 gap-6 max-w-6xl mx-auto">
          {/* Question 1 */}
          <div className="relative group">
            <div className="absolute inset-0 bg-gradient-to-br from-green-500/10 to-emerald-500/10 rounded-2xl blur-xl opacity-0 group-hover:opacity-100 transition-all duration-500"></div>
            <div className="relative glass-dark p-8 rounded-2xl border border-white/10 group-hover:border-green-500/40 transition-all duration-300 h-full">
              <div className="flex items-start space-x-4">
                <div className="flex-shrink-0 w-12 h-12 rounded-xl bg-gradient-to-br from-green-500 to-emerald-500 flex items-center justify-center text-black font-black text-xl shadow-lg shadow-green-500/50">
                  1
                </div>
                <div className="flex-1">
                  <h3 className="text-xl font-bold text-green-400 mb-3 group-hover:text-green-300 transition-colors">
                    Banko iddaa tahmini nedir?
                  </h3>
                  <p className="text-foreground/80 leading-relaxed">
                    Banko iddaa tahmini, yüksek ihtimalle tutması beklenen ve güvenilir olarak değerlendirilen 
                    maç tahminleridir. Genellikle düşük oranlı ancak yüksek tutma olasılığına sahip tahminlerdir.
                  </p>
                </div>
              </div>
            </div>
          </div>

          {/* Question 2 */}
          <div className="relative group">
            <div className="absolute inset-0 bg-gradient-to-br from-yellow-500/10 to-amber-500/10 rounded-2xl blur-xl opacity-0 group-hover:opacity-100 transition-all duration-500"></div>
            <div className="relative glass-dark p-8 rounded-2xl border border-white/10 group-hover:border-yellow-500/40 transition-all duration-300 h-full">
              <div className="flex items-start space-x-4">
                <div className="flex-shrink-0 w-12 h-12 rounded-xl bg-gradient-to-br from-yellow-500 to-amber-500 flex items-center justify-center text-black font-black text-xl shadow-lg shadow-yellow-500/50">
                  2
                </div>
                <div className="flex-1">
                  <h3 className="text-xl font-bold text-yellow-400 mb-3 group-hover:text-yellow-300 transition-colors">
                    Bugünkü iddaa tahminleri nasıl bulabilirim?
                  </h3>
                  <p className="text-foreground/80 leading-relaxed">
                    Ana sayfamızda ve kuponlar bölümünde bugünkü iddaa maç tahminlerini, güncel iddaa kupon 
                    önerilerini ve analizli tahminleri bulabilirsiniz. Her gün güncellenen içerikler mevcuttur.
                  </p>
                </div>
              </div>
            </div>
          </div>

          {/* Question 3 */}
          <div className="relative group">
            <div className="absolute inset-0 bg-gradient-to-br from-emerald-500/10 to-green-500/10 rounded-2xl blur-xl opacity-0 group-hover:opacity-100 transition-all duration-500"></div>
            <div className="relative glass-dark p-8 rounded-2xl border border-white/10 group-hover:border-emerald-500/40 transition-all duration-300 h-full">
              <div className="flex items-start space-x-4">
                <div className="flex-shrink-0 w-12 h-12 rounded-xl bg-gradient-to-br from-emerald-500 to-green-500 flex items-center justify-center text-black font-black text-xl shadow-lg shadow-emerald-500/50">
                  3
                </div>
                <div className="flex-1">
                  <h3 className="text-xl font-bold text-emerald-400 mb-3 group-hover:text-emerald-300 transition-colors">
                    Ücretsiz iddaa tahminleri güvenilir mi?
                  </h3>
                  <p className="text-foreground/80 leading-relaxed">
                    Platformumuzda profesyonel tahmincilar tarafından paylaşılan ücretsiz iddaa tahminleri, 
                    detaylı analizlere dayanmaktadır. Başarı oranları şeffaf şekilde gösterilir.
                  </p>
                </div>
              </div>
            </div>
          </div>

          {/* Question 4 */}
          <div className="relative group">
            <div className="absolute inset-0 bg-gradient-to-br from-blue-500/10 to-cyan-500/10 rounded-2xl blur-xl opacity-0 group-hover:opacity-100 transition-all duration-500"></div>
            <div className="relative glass-dark p-8 rounded-2xl border border-white/10 group-hover:border-blue-500/40 transition-all duration-300 h-full">
              <div className="flex items-start space-x-4">
                <div className="flex-shrink-0 w-12 h-12 rounded-xl bg-gradient-to-br from-blue-500 to-cyan-500 flex items-center justify-center text-black font-black text-xl shadow-lg shadow-blue-500/50">
                  4
                </div>
                <div className="flex-1">
                  <h3 className="text-xl font-bold text-blue-400 mb-3 group-hover:text-blue-300 transition-colors">
                    Yüksek oranlı iddaa tahmini riskli midir?
                  </h3>
                  <p className="text-foreground/80 leading-relaxed">
                    Yüksek oranlı iddaa tahminleri daha yüksek kazanç potansiyeli sunar ancak risk de artar. 
                    Platformumuzda hem banko hem de yüksek oranlı tahminler dengelenerek sunulur.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>

        {/* Bottom CTA */}
        <div className="relative z-10 text-center mt-12">
          <p className="text-foreground/60 mb-4">Başka sorularınız mı var?</p>
          <a href="/sss" className="inline-flex items-center space-x-2 text-green-400 hover:text-green-300 font-semibold transition-colors">
            <span>Tüm SSS'leri Görüntüle</span>
            <ArrowRight className="h-4 w-4" />
          </a>
        </div>
      </article>
    </section>
  )
}

