'use client'

import { Button } from '@/components/ui/button'
import { Trophy, TrendingUp, Users, ArrowRight } from 'lucide-react'
import Link from 'next/link'

export default function Hero() {
  // Static values for demo
  const latestCoupon: any = null
  const totalUsers = 37
  const totalCoupons = 9
  const winRate = 78
  return (
    <section className="relative overflow-hidden pt-8 pb-16 md:pt-12 md:pb-24 grid-pattern">
      <div className="container mx-auto px-4 relative z-10">
        <div className="max-w-4xl">
          {/* Left Aligned Content */}
          <div className="space-y-8 animate-fadeInUp text-left">
            <h1 className="text-5xl md:text-6xl lg:text-7xl font-bold leading-tight">
              <span className="gradient-text neon-text-green">İddaa Tahminleri</span>
              <br />
              ve Banko Kupon Önerileri
            </h1>
            
            <p className="text-xl text-foreground/70 leading-relaxed">
              Bugünkü iddaa maç tahminleri, analizli iddaa tahminleri ve{' '}
              <span className="text-green-400 font-semibold">yüksek oranlı banko tahminler</span> ile{' '}
              <span className="text-yellow-400 font-semibold">güncel iddaa kupon önerileri</span> burada!
            </p>

            <div className="flex flex-col sm:flex-row gap-4">
              <Link href="/kayit">
                <Button size="lg" className="text-lg h-14 px-8 bg-gradient-to-r from-green-500 to-yellow-400 hover:from-green-600 hover:to-yellow-500 text-black font-bold btn-premium neon-green">
                  Hemen Başla
                  <ArrowRight className="ml-2 h-5 w-5" />
                </Button>
              </Link>
              <Link href="/kuponlar">
                <Button size="lg" variant="outline" className="text-lg h-14 px-8 border-white/20 hover:border-green-500/50 hover:bg-green-500/10 hover:text-green-400">
                  Kuponları İncele
                </Button>
              </Link>
            </div>

            {/* Premium Stats */}
            <div className="grid grid-cols-3 gap-6 pt-8 max-w-2xl">
              <div className="glass-dark p-4 rounded-xl border border-white/5 card-premium">
                <div className="flex items-center space-x-2 mb-2">
                  <Users className="h-5 w-5 text-green-400" />
                  <span className="text-3xl font-bold gradient-text">
                    {totalUsers >= 1000 ? `${(totalUsers / 1000).toFixed(0)}K+` : totalUsers}
                  </span>
                </div>
                <p className="text-sm text-foreground/60">Aktif Kullanıcı</p>
              </div>
              <div className="glass-dark p-4 rounded-xl border border-white/5 card-premium">
                <div className="flex items-center space-x-2 mb-2">
                  <TrendingUp className="h-5 w-5 text-yellow-400" />
                  <span className="text-3xl font-bold gradient-text">
                    {totalCoupons >= 1000 ? `${(totalCoupons / 1000).toFixed(0)}K+` : totalCoupons}
                  </span>
                </div>
                <p className="text-sm text-foreground/60">Paylaşılan Kupon</p>
              </div>
              <div className="glass-dark p-4 rounded-xl border border-white/5 card-premium">
                <div className="flex items-center space-x-2 mb-2">
                  <Trophy className="h-5 w-5 text-green-400" />
                  <span className="text-3xl font-bold gradient-text">%{winRate}</span>
                </div>
                <p className="text-sm text-foreground/60">Başarı Oranı</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
