'use client'

import Link from 'next/link'
import { Bot } from 'lucide-react'

export default function FloatingAIButton() {
  return (
    <Link 
      href="/ai-tahmin"
      className="fixed left-6 top-1/2 -translate-y-1/2 z-[100] group"
      title="AI Maç Tahminleri"
    >
      <div className="relative">
        {/* Glow */}
        <div className="absolute inset-0 bg-gradient-to-br from-green-500 to-yellow-400 rounded-full blur-md opacity-60 group-hover:opacity-100 transition-opacity"></div>
        
        {/* Button */}
        <div className="relative w-14 h-14 bg-gradient-to-br from-green-500 to-yellow-400 rounded-full shadow-lg hover:scale-110 transition-all duration-300 flex items-center justify-center">
          <Bot className="h-7 w-7 text-black" />
          
          {/* AI Badge */}
          <div className="absolute -top-0.5 -right-0.5 w-5 h-5 bg-yellow-400 rounded-full flex items-center justify-center border-2 border-background">
            <span className="text-[8px] font-black text-black">AI</span>
          </div>
          
          {/* Active dot */}
          <div className="absolute -bottom-0.5 -left-0.5 w-3 h-3 bg-green-400 rounded-full border-2 border-background animate-pulse"></div>
        </div>
      </div>
    </Link>
  )
}

