'use client'

import { useEffect, useState } from 'react'
import CouponCard from './CouponCard'
import { Bot, Sparkles } from 'lucide-react'

export default function AITahminler() {
  const [aiCoupons, setAiCoupons] = useState<any[]>([])
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    loadAICoupons()
  }, [])

  const loadAICoupons = async () => {
    try {
      const res = await fetch('/api/kuponlar?limit=50')
      if (res.ok) {
        const data = await res.json()
        // Sadece AI tarafından oluşturulan kuponları filtrele
        const aiOnly = (data.coupons || []).filter((c: any) => c.aiGenerated === true)
        setAiCoupons(aiOnly.slice(0, 4)) // İlk 4 tanesini al
      }
    } catch (error) {
      console.error('AI kuponları yüklenirken hata:', error)
    } finally {
      setLoading(false)
    }
  }

  // Eğer AI kupon yoksa hiç gösterme
  if (loading || aiCoupons.length === 0) {
    return null
  }

  return (
    <div className="py-16 relative bg-gradient-to-b from-transparent via-purple-500/5 to-transparent">
      <div className="container mx-auto px-4">
        <div className="flex items-center justify-between mb-8">
          <div className="flex items-center space-x-3">
            <div className="relative">
              <Bot className="h-8 w-8 text-purple-400 animate-pulse" />
              <Sparkles className="absolute -top-1 -right-1 h-4 w-4 text-yellow-400" />
            </div>
            <div>
              <h2 className="text-3xl font-bold gradient-text">AI Tahminleri</h2>
              <p className="text-sm text-foreground/60">ChatGPT ile Oluşturulan Profesyonel Tahminler</p>
            </div>
          </div>
          <a href="/kuponlar" className="text-sm text-purple-400 hover:text-purple-300 transition-colors font-semibold">
            Tüm AI Tahminleri →
          </a>
        </div>

        {/* Info Banner */}
        <div className="mb-8 glass-dark p-4 rounded-xl border border-purple-500/20 bg-gradient-to-r from-purple-500/10 to-pink-500/10">
          <div className="flex items-center space-x-3">
            <Bot className="h-5 w-5 text-purple-400 flex-shrink-0" />
            <p className="text-sm text-foreground/80">
              <span className="font-bold text-purple-400">Yapay Zeka Destekli Tahminler:</span> ChatGPT tarafından analiz edilen ve oluşturulan profesyonel maç tahminleri
            </p>
          </div>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {aiCoupons.map((coupon) => (
            <CouponCard key={coupon.id} coupon={coupon} />
          ))}
        </div>
      </div>
    </div>
  )
}



