import type { Metadata } from 'next'
import { Inter } from 'next/font/google'
import './globals.css'
import SessionProvider from '@/components/SessionProvider'

const inter = Inter({ subsets: ['latin'] })

export const metadata: Metadata = {
  title: 'İddaa Tahminleri - Banko İddaa Tahmin | Bugünkü Maç Tahminleri ve Kupon Önerileri',
  description: 'Güncel iddaa tahminleri, banko iddaa tahmini, bugünkü iddaa maç tahminleri ve analizleri. Ücretsiz iddaa kupon önerileri, yüksek oranlı tahminler ve Süper Lig analiz yorumları. Profesyonel bahis tahmini sitesi.',
  keywords: 'iddaa tahminleri, banko iddaa tahmini, iddaa maç tahminleri bugün, bugünkü iddaa tahminleri, haftalık iddaa kupon önerileri, banko kupon iddaa, yüksek oranlı iddaa tahmini, analizli iddaa tahminleri, Süper Lig iddaa tahmini yorumları, iddaa oran tahminleri, güncel iddaa tahminleri, ücretsiz iddaa tahminleri, bahis tahmini sitesi, iddaa tahmin sitesi, iddaa yorumları, iddaa analizleri, maç sonucu tahmini, üst alt tahmin, karşılıklı gol tahmini, iddaa kupon paylaşımı',
  authors: [{ name: 'İddaaSohbet Analiz Ekibi' }],
  creator: 'İddaaSohbet',
  publisher: 'İddaaSohbet',
  formatDetection: {
    email: false,
    address: false,
    telephone: false,
  },
  icons: {
    icon: '/icon',
  },
  metadataBase: new URL('https://iddaasohbet.com'),
  alternates: {
    canonical: '/',
  },
  openGraph: {
    type: 'website',
    locale: 'tr_TR',
    url: 'https://iddaasohbet.com',
    title: 'İddaa Tahminleri - Banko İddaa Tahmin | Bugünkü Maç Tahminleri',
    description: 'Güncel iddaa tahminleri, banko iddaa tahmini ve bugünkü maç tahminleri. Ücretsiz iddaa kupon önerileri ve profesyonel analizler.',
    siteName: 'İddaaSohbet',
    images: [{
      url: '/og-image.jpg',
      width: 1200,
      height: 630,
      alt: 'İddaaSohbet - İddaa Tahminleri ve Kupon Paylaşımı',
    }],
  },
  twitter: {
    card: 'summary_large_image',
    title: 'İddaa Tahminleri - Banko İddaa Tahmin',
    description: 'Güncel iddaa tahminleri ve banko kupon önerileri',
    images: ['/og-image.jpg'],
  },
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      'max-video-preview': -1,
      'max-image-preview': 'large',
      'max-snippet': -1,
    },
  },
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="tr" suppressHydrationWarning>
      <body className={inter.className} suppressHydrationWarning>
        <SessionProvider>
          {children}
        </SessionProvider>
      </body>
    </html>
  )
}