'use client'

import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card'
import { Badge } from '@/components/ui/badge'
import { 
  Bell,
  Info,
  Zap,
  Smartphone,
  Mail,
  Globe,
  CheckCircle,
  MessageSquare,
  Clock
} from 'lucide-react'

export default function AdminBildirimlerPage() {
  const features = [
    {
      icon: Bell,
      title: 'Push Bildirimleri',
      description: 'Kullanıcılara anlık push bildirimleri gönder',
      color: 'blue',
      status: 'planned'
    },
    {
      icon: Mail,
      title: 'Email Bildirimleri',
      description: 'Toplu email kampanyaları oluştur ve gönder',
      color: 'green',
      status: 'planned'
    },
    {
      icon: Globe,
      title: 'Site İçi Bildirimler',
      description: 'Platfor m içinde bildirim merkezi',
      color: 'purple',
      status: 'planned'
    },
    {
      icon: Zap,
      title: 'Otomatik Bildirimler',
      description: 'Kupon sonuçları, takipçi aktiviteleri için otomatik bildirimler',
      color: 'yellow',
      status: 'planned'
    }
  ]

  return (
    <div className="space-y-6">
      {/* Page Header */}
      <div className="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
        <div>
          <h1 className="text-3xl font-bold gradient-text mb-2">Bildirim Sistemi</h1>
          <p className="text-foreground/60">Kullanıcı bildirim özellikleri</p>
        </div>
      </div>

      {/* Info Card */}
      <Card className="glass-dark border-blue-500/30 bg-gradient-to-r from-blue-500/5 to-cyan-500/5">
        <CardContent className="p-6">
          <div className="flex items-start space-x-4">
            <div className="h-12 w-12 rounded-xl bg-blue-500/20 border border-blue-500/30 flex items-center justify-center flex-shrink-0">
              <Info className="h-6 w-6 text-blue-400" />
            </div>
            <div>
              <h3 className="font-bold text-lg mb-2 text-blue-400">Bildirim Sistemi Geliştirilme Aşamasında</h3>
              <p className="text-foreground/70 mb-3">
                Platform için kapsamlı bir bildirim sistemi planlanmaktadır. Bu sistem kullanıcılara önemli güncellemeler, 
                kupon sonuçları ve diğer aktiviteler hakkında bilgi verecektir.
              </p>
              <div className="flex items-center space-x-2">
                <Badge className="bg-yellow-500/20 border-yellow-500/30 text-yellow-400">
                  <Clock className="h-3 w-3 mr-1" />
                  Yakında
                </Badge>
              </div>
            </div>
          </div>
        </CardContent>
      </Card>

      {/* Planned Features */}
      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        {features.map((feature, index) => {
          const Icon = feature.icon
          const colorClasses = {
            blue: { bg: 'bg-blue-500/10 border-blue-500/30', text: 'text-blue-400' },
            green: { bg: 'bg-green-500/10 border-green-500/30', text: 'text-green-400' },
            purple: { bg: 'bg-purple-500/10 border-purple-500/30', text: 'text-purple-400' },
            yellow: { bg: 'bg-yellow-500/10 border-yellow-500/30', text: 'text-yellow-400' }
          }
          const colors = colorClasses[feature.color as keyof typeof colorClasses]
          
          return (
            <Card key={index} className="glass-dark border-white/5 hover:border-white/10 transition-all">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className={`h-14 w-14 rounded-xl ${colors.bg} border flex items-center justify-center flex-shrink-0`}>
                    <Icon className={`h-7 w-7 ${colors.text}`} />
                  </div>
                  <div className="flex-1">
                    <h3 className="font-bold text-lg mb-2">{feature.title}</h3>
                    <p className="text-sm text-foreground/60 mb-3">{feature.description}</p>
                    <Badge className="bg-yellow-500/20 border-yellow-500/30 text-yellow-400 text-xs">
                      Planlanıyor
                    </Badge>
                  </div>
                </div>
              </CardContent>
            </Card>
          )
        })}
      </div>

      {/* Current Notifications via Chat */}
      <Card className="glass-dark border-white/5">
        <CardHeader className="border-b border-white/5">
          <CardTitle className="flex items-center space-x-2">
            <MessageSquare className="h-5 w-5 text-green-400" />
            <span>Mevcut Bildirim Yöntemleri</span>
          </CardTitle>
        </CardHeader>
        <CardContent className="p-6">
          <div className="space-y-4">
            <div className="flex items-start space-x-3 p-4 glass rounded-lg border border-green-500/20">
              <CheckCircle className="h-5 w-5 text-green-400 mt-0.5" />
              <div>
                <p className="font-semibold text-green-400 mb-1">Canlı Sohbet</p>
                <p className="text-sm text-foreground/70">
                  Kullanıcılar platformdaki canlı sohbet özelliğini kullanarak gerçek zamanlı iletişim kurabilirler.
                </p>
              </div>
            </div>

            <div className="flex items-start space-x-3 p-4 glass rounded-lg border border-green-500/20">
              <CheckCircle className="h-5 w-5 text-green-400 mt-0.5" />
              <div>
                <p className="font-semibold text-green-400 mb-1">Direkt Mesajlaşma</p>
                <p className="text-sm text-foreground/70">
                  Kullanıcılar birbirlerine özel mesaj gönderebilirler. Admin panelinden kullanıcılara mesaj atılabilir.
                </p>
              </div>
            </div>

            <div className="flex items-start space-x-3 p-4 glass rounded-lg border border-green-500/20">
              <CheckCircle className="h-5 w-5 text-green-400 mt-0.5" />
              <div>
                <p className="font-semibold text-green-400 mb-1">Kupon Yorumları</p>
                <p className="text-sm text-foreground/70">
                  Kullanıcılar kuponlar altında yorum yapabilir ve etkileşimde bulunabilirler.
                </p>
              </div>
            </div>
          </div>
        </CardContent>
      </Card>
    </div>
  )
}
