import { Metadata } from 'next'

export const metadata: Metadata = {
  title: 'İddaa Analiz ve Tahmin Blogları | İddaa Stratejileri ve Yorumlar',
  description: 'İddaa tahmin stratejileri, maç analizleri, Süper Lig yorumları ve bahis ipuçları. Profesyonel analistlerden iddaa tahmin teknikleri, bankroll yönetimi ve kazanç stratejileri.',
  keywords: 'iddaa analizleri, iddaa yorumları, iddaa stratejileri, maç analizi, Süper Lig tahminleri, bahis ipuçları, iddaa blog, tahmin teknikleri',
  openGraph: {
    title: 'İddaa Analiz ve Tahmin Blogları',
    description: 'İddaa tahmin stratejileri ve profesyonel analizler',
    url: 'https://iddaasohbet.com/blog',
  },
  alternates: {
    canonical: 'https://iddaasohbet.com/blog',
  },
}

export default function BlogLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return <>{children}</>
}



