# 🎯 İDDAASO HBET YAZILIMI - SATIŞ PAKETİ

## ✅ KURULUM TAMAMLANDI!

**Tarih:** 01 Kasım 2025  
**Yazılım:** İddaaSohbet Platform v1.0  
**Geliştirici:** Cihatsoft  
**Lisans Tipi:** Şifreli Database License System

---

## 🔐 LİSANS SİSTEMİ

### ✅ Aktif Koruma Katmanları:

1. **Middleware Domain Kontrolü** ⚡
   - Her HTTP isteğinde otomatik kontrol
   - Farklı domain = Anında 403 hatası

2. **Şifreli Database License** 🔒
   - AES-256 şifreleme
   - SHA-512 hash doğrulama
   - Domain encrypted olarak saklanır

3. **Runtime Validation** 🛡️
   - Kritik işlemlerde tekrar kontrol
   - Tamper-proof system

4. **Expire Date Check** ⏰
   - Otomatik süre kontrolü
   - 1 yıl geçerli (01.11.2026)

---

## 📦 MÜŞTERİYE TESLİM

### Verilecek Dosyalar:
```
✅ Tüm proje dosyaları
✅ package.json
✅ .env.example (şifreleri temizlenmiş)
✅ LICENSE_INFO.md
❌ node_modules (müşteri kuracak)
❌ .env (hassas bilgiler var)
```

### Müşteri Kurulum Adımları:

1. **Dosyaları Hosting'e Yükle**
   - Vercel/Railway/Hosting'e deploy

2. **Environment Variables Ayarla**
   ```env
   DATABASE_URL=mysql://...  (müşterinin db'si)
   NEXTAUTH_URL=https://iddaasohbet.com
   NEXTAUTH_SECRET=... (yeni generate et)
   APIFOOTBALL_KEY=... (müşterinin kendi API key'i)
   ```

3. **Build & Deploy**
   ```bash
   npm install
   npx prisma generate
   npm run build
   ```

4. **Domain Ayarı**
   - iddaasohbet.com → Hosting'e yönlendir
   - www.iddaasohbet.com → Otomatik redirect

---

## 🚨 GÜVENLİK DETAYLARI

### ✅ Çalışacak Domainler:
- ✅ `iddaasohbet.com`
- ✅ `www.iddaasohbet.com`
- ✅ `localhost` (development için)
- ✅ `127.0.0.1` (development için)

### ❌ Çalışmayacak Domainler:
- ❌ `başka-site.com`
- ❌ `test-domain.com`
- ❌ `192.168.x.x` (başka local IP)

### Bypass Girişimleri:

**Müşteri şunları yaparsa sistem DURACAK:**
- ❌ `middleware.ts` dosyasını silerse
- ❌ `lib/license.ts` dosyasını silerse
- ❌ `SystemLicense` tablosunu database'den silerse
- ❌ ENCRYPTION_KEY'i değiştirirse
- ❌ Hash doğrulama kodunu silerse

**Kurtarma:** Neredeyse imkansız çünkü:
- Şifreleme anahtarı kod içinde gömülü
- Çoklu kontrol noktası var
- Hash doğrulama şart

---

## 💰 FİYATLANDIRMA TAVSİYESİ

### Tek Domain Lisansı:
- **Yazılım:** $XXX - $XXX (senin belirleyeceğin)
- **1 Yıl Destek:** $XXX
- **Kurulum & Eğitim:** $XXX

### Ekstra Domainler:
- **Her ek domain:** $XXX
- **Sınırsız domain:** $XXX (enterprise)

---

## 🛠️ DESTEK & BAKIM

### Müşteri Sorarsa:

**"Domain değiştirebilir miyim?"**
→ Hayır, sistem sadece iddaasohbet.com için lisanslı.
→ Değiştirmek için yeni lisans gerekir.

**"Localhost'ta çalışır mı?"**
→ Evet, development için localhost izinli.

**"Kodları değiştirebilir miyim?"**
→ Evet ama license dosyalarına dokunursa sistem duracak.

**"Lisans süresi bitti ne olur?"**
→ Sistem otomatik kapanır.
→ Yenilemek için sana başvurması gerekir.

---

## 🔑 LİSANS YENİLEME (Senin İçin)

### Müşteri lisansı yenilemek isterse:

**Seçenek 1: Uzaktan (Önerilen)**
- Database'e erişim al
- `SystemLicense` tablosunda `expiresAt` tarihini güncelle
- Veya `active` = false yap (iptal için)

**Seçenek 2: Script Gönder**
```bash
# Yeni kurulum script'i gönder
npx tsx scripts/setup-license.ts iddaasohbet.com
```

---

## 📊 SİSTEM BİLGİLERİ

### Teknoloji Stack:
- ⚛️ Next.js 15.5.4
- ⚡ React 19.0.0
- 🗄️ Prisma ORM
- 🔐 NextAuth
- 💾 MySQL Database
- 🎨 Tailwind CSS
- ⚽ API-Football Integration

### Özellikler:
- ✅ Admin Panel (10 sayfa)
- ✅ Kupon Paylaşım Sistemi
- ✅ Canlı Sohbet
- ✅ Direkt Mesajlaşma
- ✅ Canlı Skorlar
- ✅ Kullanıcı Yönetimi
- ✅ İstatistik ve Raporlama
- ✅ Responsive Tasarım
- ✅ SEO Optimized

---

## 📞 İLETİŞİM

**Geliştirici:** Cihatsoft  
**Website:** cihatsoft.com  
**Proje:** İddaaSohbet Platform  
**Lisans:** Domain-Locked Commercial License

---

## ⚖️ YASAL UYARI

Bu yazılım telif hakları ile korunmaktadır.
Yetkisiz kullanım, kopyalama, dağıtım yasaktır.
Sadece lisanslı domain'de kullanılabilir.

**© 2025 Cihatsoft - Tüm hakları saklıdır.**

---

## 🎁 BONUS: Müşteriye Verilebilecekler

- ✅ 1 Yıllık API-Football Desteği
- ✅ Kurulum Asistanlığı
- ✅ 3 Ay Ücretsiz Teknik Destek
- ✅ Video Eğitim Materyalleri
- ✅ Kullanım Kılavuzu

---

## ✨ SON KONTROL LİSTESİ

Müşteriye teslim etmeden önce:

- [ ] .env dosyasındaki hassas bilgileri temizle
- [ ] .env.example oluştur (template olarak)
- [ ] node_modules sil (müşteri npm install yapacak)
- [ ] .next build klasörünü sil
- [ ] LICENSE_INFO.md dosyasını ekle
- [ ] Kullanıcı kılavuzu hazırla (opsiyonel)
- [ ] Test et: başka domain'de çalışmadığından emin ol

---

**🎊 SİSTEM HAZIR! İYİ SATIŞLAR!** 🚀





