const fs = require('fs');

function loadNickler() {
  try {
    if (fs.existsSync('./nickler.json')) {
      return JSON.parse(fs.readFileSync('./nickler.json', 'utf-8'));
    }
  } catch {}
  return {};
}

function saveNickler(data) {
  try {
    fs.writeFileSync('./nickler.json', JSON.stringify(data, null, 2));
  } catch {}
}

module.exports = {
  name: 'guildMemberRemove',
  async execute(member) {
    try {
      const db = loadNickler();
      const gid = member.guild.id;
      const uid = member.id;

      if (!db[gid]) return;

      for (const k of Object.keys(db[gid])) {
        if (db[gid][k] === uid) delete db[gid][k];
      }

      saveNickler(db);
    } catch {}
  }
};
