const {
  SlashCommandBuilder,
  PermissionFlagsBits,
  EmbedBuilder,
  ActionRowBuilder,
  StringSelectMenuBuilder,
  ChannelType
} = require('discord.js');

/* =========================
   ✅ DOLDURULDU: Rol ID + Emoji ID
========================= */

const ROLE_IDS = {
  kirmizi: '1451676154103730336',
  mavi:    '1451676714882043955',
  pembe:   '1451676989894168677',
  sari:    '1451676574284775475',
};

const EMOJIS = {
  kirmizi: '1451674051188752557',
  mavi:    '1451674362024562739',
  pembe:   '1451665626090307765',
  sari:    '1451665866298097674',
};

// Embed içinde custom emoji göstermek için (name önemli değil, id yeter)
const EMBED_EMOJI = {
  kirmizi: `<:kirmizi:${EMOJIS.kirmizi}>`,
  mavi:    `<:mavi:${EMOJIS.mavi}>`,
  pembe:   `<:pembe:${EMOJIS.pembe}>`,
  sari:    `<:sari:${EMOJIS.sari}>`,
};

const COLORS = [
  { key: 'kirmizi', label: 'Kırmızı' },
  { key: 'mavi',    label: 'Mavi' },
  { key: 'pembe',   label: 'Pembe' },
  { key: 'sari',    label: 'Sarı' },
];

function pickEmoji(guild, key) {
  const id = EMOJIS[key];
  if (!id) return undefined;
  const e = guild.emojis.cache.get(id);
  return e ? { id: e.id, name: e.name, animated: e.animated } : { id };
}

module.exports = {
  data: new SlashCommandBuilder()
    .setName('renk-kur')
    .setDescription('Renk rolleri panelini kurar (ROL ID + custom emoji).')
    .setDefaultMemberPermissions(PermissionFlagsBits.Administrator)
    .addChannelOption(opt =>
      opt.setName('kanal')
        .setDescription('Panelin gönderileceği kanal')
        .addChannelTypes(ChannelType.GuildText)
        .setRequired(true)
    ),

  async execute(interaction, client) {
    const kanal = interaction.options.getChannel('kanal');
    if (!kanal) {
      return interaction.reply({ content: '⚠️ Kanal bulunamadı.', ephemeral: true });
    }

    // Rol var mı kontrol (ID ile)
    const missingRoles = [];
    for (const c of COLORS) {
      const rid = ROLE_IDS[c.key];
      if (!rid) missingRoles.push(c.label);
      else {
        const role = interaction.guild.roles.cache.get(rid);
        if (!role) missingRoles.push(`${c.label} (rol yok)`);
      }
    }
    if (missingRoles.length) {
      return interaction.reply({
        content: `⚠️ Bu renklerin rol ID’si hatalı/rol bulunamadı:\n• ${missingRoles.join('\n• ')}`,
        ephemeral: true
      });
    }

    // Ayarlara kaydet
    const ayarlar = client.loadAyarlar();
    if (!ayarlar[interaction.guild.id]) ayarlar[interaction.guild.id] = {};
    ayarlar[interaction.guild.id].renkRolPanel = {
      channelId: kanal.id,
      roles: ROLE_IDS
    };
    client.saveAyarlar(ayarlar);

const embed = new EmbedBuilder()
  .setColor('#5865F2')
  .setTitle('H A B N E T')
  .setThumbnail('https://cdn.discordapp.com/avatars/1451581445490475028/6419aa22a87fe9310ed975a850d7b1f5?size=256')
  .setDescription(
    [
      'Aşağıdaki menüden **tek tık** ile rengini seç.',
      'Seçtiğin anda eski renk otomatik kalkar.',
      '',
      '━ **Renkler** ━',
      `${EMBED_EMOJI.kirmizi} **Kırmızı**  —  güçlü & net`,
      `${EMBED_EMOJI.mavi} **Mavi**     —  sakin & cool`,
      `${EMBED_EMOJI.pembe} **Pembe**   —  soft & tatlı`,
      `${EMBED_EMOJI.sari} **Sarı**     —  enerjik & parlak`,
      '',
      '_İstediğin zaman tekrar değiştir._'
    ].join('\n')
  )
  .setFooter({ text: 'developed by rilaks' })
  .setTimestamp();


    const menu = new StringSelectMenuBuilder()
      .setCustomId('renk_rol_sec')
      .setPlaceholder('Rengini seç')
      .addOptions([
        ...COLORS.map(c => ({
          label: c.label,
          value: c.key,
          emoji: pickEmoji(interaction.guild, c.key),
          description: `${c.label} rengini al`
        })),
        {
          label: 'Renk rolümü kaldır',
          value: 'remove',
          emoji: { name: '🧹' },
          description: 'Üstündeki renk rolünü kaldırır'
        }
      ]);

    const row = new ActionRowBuilder().addComponents(menu);

    await kanal.send({ embeds: [embed], components: [row] }).catch(() => {});
    await interaction.reply({ content: `✅ Renk paneli ${kanal} kanalına kuruldu.`, ephemeral: true });
  },

  async handleInteraction(interaction, client) {
    if (!interaction.isStringSelectMenu()) return;
    if (interaction.customId !== 'renk_rol_sec') return;

    const ayarlar = client.loadAyarlar();
    const roleMap = ayarlar[interaction.guild.id]?.renkRolPanel?.roles;
    if (!roleMap) {
      return interaction.reply({ content: '⚠️ Panel ayarı bulunamadı. `/renk-kur` ile kur.', ephemeral: true });
    }

    const selected = interaction.values[0];
    const allRoleIds = Object.values(roleMap);

    // Eski renk rollerini kaldır
    const toRemove = interaction.member.roles.cache
      .filter(r => allRoleIds.includes(r.id))
      .map(r => r.id);

    if (toRemove.length) {
      await interaction.member.roles.remove(toRemove).catch(() => {});
    }

    if (selected === 'remove') {
      return interaction.reply({ content: '🧹 Renk rolün kaldırıldı.', ephemeral: true });
    }

    const targetRoleId = roleMap[selected];
    if (!targetRoleId) {
      return interaction.reply({ content: '⚠️ Rol bulunamadı.', ephemeral: true });
    }

    await interaction.member.roles.add(targetRoleId).catch(() => {});
    return interaction.reply({ content: '✅ Renk rolün verildi.', ephemeral: true });
  }
};
