const { SlashCommandBuilder, PermissionFlagsBits, ChannelType, EmbedBuilder } = require('discord.js');

module.exports = {
  data: new SlashCommandBuilder()
    .setName('kanal-kur')
    .setDescription('Nick-only kayıt sistemi kanallarını ve rollerini kurar.')
    .setDefaultMemberPermissions(PermissionFlagsBits.Administrator),

  async execute(interaction) {
    const guild = interaction.guild;

    // 1️⃣ Kategori
    let kategori = guild.channels.cache.find(
      c => c.name === '📚 | Kayıt Sistemi' && c.type === ChannelType.GuildCategory
    );

    if (!kategori) {
      kategori = await guild.channels.create({
        name: '📚 | Kayıt Sistemi',
        type: ChannelType.GuildCategory,
        permissionOverwrites: [
          {
            id: guild.roles.everyone.id,
            deny: ['SendMessages', 'Connect'],
          },
        ],
      });
    }

    // 2️⃣ Kayıt Bilgi Kanalı (salt okunur)
    let bilgiKanal = guild.channels.cache.find(
      c => c.name === '📕 | Kayıt Bilgi' && c.parentId === kategori.id
    );

    if (!bilgiKanal) {
      bilgiKanal = await guild.channels.create({
        name: '📕 | Kayıt Bilgi',
        type: ChannelType.GuildText,
        parent: kategori.id,
        permissionOverwrites: [
          {
            id: guild.roles.everyone.id,
            deny: ['SendMessages'],
          },
        ],
      });
    }

    // 3️⃣ Kayıt Kanalı
    let kayitKanal = guild.channels.cache.find(
      c => c.name === '📝 | Kayıt Kanalı' && c.parentId === kategori.id
    );

    if (!kayitKanal) {
      kayitKanal = await guild.channels.create({
        name: '📝 | Kayıt Kanalı',
        type: ChannelType.GuildText,
        parent: kategori.id,
        permissionOverwrites: [
          {
            id: guild.roles.everyone.id,
            allow: ['ViewChannel', 'SendMessages'],
          },
        ],
      });
    }

    // 4️⃣ Ses Teyit Kanalı
    let sesKanal = guild.channels.cache.find(
      c => c.name === '🔊 | Ses Teyit' && c.parentId === kategori.id
    );

    if (!sesKanal) {
      sesKanal = await guild.channels.create({
        name: '🔊 | Ses Teyit',
        type: ChannelType.GuildVoice,
        parent: kategori.id,
      });
    }

    // 5️⃣ Roller (SADECE gerekli olanlar)
    const roller = [
      { name: 'Kayitsiz', color: 0x808080 },
      { name: 'Üye', color: 0x5865F2 },
    ];

    for (const rolData of roller) {
      let rol = guild.roles.cache.find(r => r.name === rolData.name);
      if (!rol) {
        await guild.roles.create({
          name: rolData.name,
          color: rolData.color,
        });
      }
    }

    // 6️⃣ Bilgilendirme Embed (Nick-only)
    const embed = new EmbedBuilder()
      .setColor('#57f287')
      .setTitle('📌 | Kayıt Sistemi Bilgilendirme')
      .setDescription(
        `Sunucuda **nick-only otomatik kayıt sistemi** aktiftir.\n\n` +
        `📝 **Kayıt Kanalı:** Bu kanala **sadece nickini** yazman yeterlidir.\n` +
        `🔊 **Ses Teyit:** Gerekli durumlarda doğrulama için kullanılır.\n\n` +
        `**Nick Kuralları:**\n` +
        `• Tek kelime (boşluk yok)\n` +
        `• Emoji / sembol yok\n` +
        `• Sadece **harf + sayı**\n\n` +
        `**Geçerli Örnekler:**\n` +
        `\`rilaks\`, \`fu\`, \`lillian\`, \`a\`, \`x7\`\n\n` +
        `❗ Yanlış nicki **spam yapanlar 3 denemede 5 dakika timeout** alır.\n\n` +
        `📎 Kayıt sonrası mesajın otomatik silinir ve rolün verilir.`
      )
      .setFooter({ text: 'Kayıt Sistemi Botu' })
      .setTimestamp();

    await bilgiKanal.send({ embeds: [embed] }).catch(() => {});

    await interaction.reply({
      content: '✅ Nick-only kayıt sistemi başarıyla kuruldu!',
      ephemeral: true
    });
  },
};
