# Radiant Gear
[![License: LGPL v3](https://img.shields.io/badge/License-LGPL%20v3-blue.svg?&style=flat-square)](https://www.gnu.org/licenses/lgpl-3.0)
[![ko-fi](https://img.shields.io/badge/Support%20Me-Ko--fi-%23FF5E5B?style=flat-square)](https://ko-fi.com/C0C1NL4O)

Radiant Gear is a mod that acts as a simple compatibility bridge between [Curios API](https://www.curseforge.com/minecraft/mc-mods/curios)
or [Trinkets API](https://www.curseforge.com/minecraft/mc-mods/trinkets) and dynamic light mods. With this mod, items in
accessory slots will inherit the dynamic lighting behavior defined by the dynamic lighting mod. As an example, if a held
torch would provide dynamic lighting, then installing this mod will cause torches placed in accessory slots to also
provide dynamic lighting.

**Please note: This mod does NOT add any content or slots on its own. In order to gain more slots or assign items into
slots, users will need to either add a mod that adds that kind of content or add it themselves.**

* [Curios API Configuration](https://github.com/TheIllusiveC4/Curios/wiki/How-to-Use:-Users)
* [Trinkets API Configuration](https://github.com/emilyploszaj/trinkets/wiki/Quick-Start-Guide)

**Compatible Mods**
- [Dynamic Lights](https://www.curseforge.com/minecraft/mc-mods/dynamic-lights)
- [Lucent](https://www.curseforge.com/minecraft/mc-mods/lucent)
- [Magnesium/Rubidium Dynamic Lights](https://www.curseforge.com/minecraft/mc-mods/dynamiclights-reforged)
- [Ars Nouveau](https://www.curseforge.com/minecraft/mc-mods/ars-nouveau)
- [LambDynamicLights](https://www.curseforge.com/minecraft/mc-mods/lambdynamiclights)

Note: This mod's sidedness depends on the dynamic lighting mod used. For example, if using Lucent then this mod is
client-side only because Lucent is client-side only. On the other hand, if using Dynamic Lights then this mod is
required on both client and server because Dynamic Lights is required on both as well.

## Downloads
**CurseForge**
- [![](http://cf.way2muchnoise.eu/short_radiant-gear_downloads%20on%20Forge.svg)](https://www.curseforge.com/minecraft/mc-mods/radiant-gear/files) [![](http://cf.way2muchnoise.eu/versions/radiant-gear.svg)](https://www.curseforge.com/minecraft/mc-mods/radiant-gear)
- [![](http://cf.way2muchnoise.eu/short_radiant-gear-fabric_downloads%20on%20Forge.svg)](https://www.curseforge.com/minecraft/mc-mods/radiant-gear-fabric/files) [![](http://cf.way2muchnoise.eu/versions/curious-lights.svg)](https://www.curseforge.com/minecraft/mc-mods/radiant-gear-fabric)

## Support

Please report all bugs, issues, and feature requests to the [issue tracker](https://github.com/TheIllusiveC4/CuriousLights/issues).

For non-technical support and questions, join the developer's [Discord](https://discord.gg/JWgrdwt).

## License

All source code and assets are licensed under LGPL 3.0.

## Donations

Donations to the developer can be sent through [Ko-fi](https://ko-fi.com/C0C1NL4O).

## Affiliates

[![BisectHosting](https://i.ibb.co/1G4QPdc/bh-illusive.png)](https://bisecthosting.com/illusive)
