/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.entity;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class EffectHelper {
    public static Applier createApplier(Supplier<? extends MobEffect> effect) {
        return new Applier(effect);
    }

    public static boolean has(Supplier<? extends MobEffect> effect, LivingEntity entity) {
        return entity.m_21023_(effect.get());
    }

    public static Optional<Integer> getAmplifier(Supplier<? extends MobEffect> effect, LivingEntity entity) {
        return Optional.ofNullable(entity.m_21124_(effect.get())).map(MobEffectInstance::m_19564_);
    }

    public static Optional<Integer> getDuration(Supplier<? extends MobEffect> effect, LivingEntity entity) {
        return Optional.ofNullable(entity.m_21124_(effect.get())).map(MobEffectInstance::m_19557_);
    }

    public static class Applier {
        final Supplier<? extends MobEffect> effect;
        Integer maxDuration = null;
        Integer maxAmplifier = null;
        int duration = 100;
        int amplifier = 0;

        public Applier duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Applier amplifier(int amplifier) {
            this.amplifier = amplifier;
            return this;
        }

        public Applier stackableDuration(int max) {
            this.maxDuration = max;
            return this;
        }

        public Applier stackableAmplifier(int max) {
            this.maxAmplifier = max;
            return this;
        }

        public void apply(LivingEntity entity) {
            int duration = this.duration;
            int amplifier = this.amplifier;
            MobEffectInstance previous = entity.m_21124_(this.effect.get());
            if (previous != null) {
                if (this.maxDuration != null) {
                    duration = Math.min(duration + previous.m_19557_(), this.maxDuration);
                }
                if (this.maxAmplifier != null) {
                    amplifier = Math.min(amplifier + previous.m_19564_() + 1, this.maxAmplifier);
                }
            }
            entity.m_7292_(new MobEffectInstance(this.effect.get(), duration, amplifier));
        }

        private Applier(Supplier<? extends MobEffect> effect) {
            this.effect = effect;
        }
    }
}

