/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.animations;

import com.majruszlibrary.animations.Animation;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.math.AnyPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class ModelDef {
    public List<GeometryDef> geometries = new ArrayList<GeometryDef>();

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition toLayerDefinition() {
        GeometryDef geometry = this.geometries.get(0);
        MeshDefinition mesh = new MeshDefinition();
        HashMap<String, Vector3f> offsets = new HashMap<String, Vector3f>();
        HashMap<String, PartDefinition> parts = new HashMap<String, PartDefinition>();
        for (BoneDef bone : geometry.bones) {
            PartPose pose;
            CubeListBuilder cubes = CubeListBuilder.m_171558_();
            for (CubeDef cube : bone.cubes) {
                Vector3f position = AnyPos.from(cube.origin).sub(bone.globalPivot).add(Float.valueOf(0.0f), Float.valueOf(cube.size.y), Float.valueOf(0.0f)).mul(Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f)).vec3f();
                cubes.m_171514_(cube.uv.x, cube.uv.y).m_171488_(position.x, position.y, position.z, cube.size.x, cube.size.y, cube.size.z, new CubeDeformation(cube.inflate.floatValue()));
            }
            bone.pivot = bone.parent != null ? AnyPos.from(bone.globalPivot).sub((Vector3f)offsets.get(bone.parent)).mul(Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f)).vec3f() : AnyPos.from(bone.globalPivot).mul(Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f)).add(0.0, 24.0, 0.0).vec3f();
            if (bone.rotation != null) {
                float toRadiansScale = (float)Math.PI / 180;
                pose = PartPose.m_171423_((float)bone.pivot.x, (float)bone.pivot.y, (float)bone.pivot.z, (float)(bone.rotation.x * toRadiansScale), (float)(bone.rotation.y * toRadiansScale), (float)(bone.rotation.z * toRadiansScale));
            } else {
                pose = PartPose.m_171419_((float)bone.pivot.x, (float)bone.pivot.y, (float)bone.pivot.z);
            }
            offsets.put(bone.name, bone.globalPivot);
            parts.put(bone.name, (bone.parent != null ? (PartDefinition)parts.get(bone.parent) : mesh.m_171576_()).m_171599_(bone.name, cubes, pose));
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)geometry.description.width, (int)geometry.description.height);
    }

    static {
        Serializables.get(ModelDef.class).define("minecraft:geometry", Reader.list(Reader.custom(GeometryDef::new)), s -> s.geometries, (s, v) -> {
            s.geometries = v;
        });
        Serializables.get(GeometryDef.class).define("description", Reader.custom(DescriptionDef::new), s -> s.description, (s, v) -> {
            s.description = v;
        }).define("bones", Reader.list(Reader.custom(BoneDef::new)), s -> s.bones, (s, v) -> {
            s.bones = v;
        });
        Serializables.get(DescriptionDef.class).define("texture_width", Reader.integer(), s -> s.width, (s, v) -> {
            s.width = v;
        }).define("texture_height", Reader.integer(), s -> s.height, (s, v) -> {
            s.height = v;
        });
        Serializables.get(BoneDef.class).define("name", Reader.string(), s -> s.name, (s, v) -> {
            s.name = v;
        }).define("parent", Reader.string(), s -> s.parent, (s, v) -> {
            s.parent = v;
        }).define("pivot", Reader.list(Reader.number()), s -> Animation.to3d(s.globalPivot), (s, v) -> {
            s.globalPivot = Animation.to3d(v);
        }).define("rotation", Reader.list(Reader.number()), s -> Animation.to3d(s.rotation), (s, v) -> {
            s.rotation = Animation.to3d(v);
        }).define("cubes", Reader.list(Reader.custom(CubeDef::new)), s -> s.cubes, (s, v) -> {
            s.cubes = v;
        });
        Serializables.get(CubeDef.class).define("origin", Reader.list(Reader.number()), s -> Animation.to3d(s.origin), (s, v) -> {
            s.origin = Animation.to3d(v);
        }).define("size", Reader.list(Reader.number()), s -> Animation.to3d(s.size), (s, v) -> {
            s.size = Animation.to3d(v);
        }).define("inflate", Reader.number(), s -> s.inflate, (s, v) -> {
            s.inflate = v;
        }).define("uv", Reader.list(Reader.integer()), s -> Animation.to2d(s.uv), (s, v) -> {
            s.uv = Animation.to2d(v);
        });
    }

    public static class GeometryDef {
        public DescriptionDef description = new DescriptionDef();
        public List<BoneDef> bones = new ArrayList<BoneDef>();
    }

    public static class BoneDef {
        public String name = "body";
        public String parent = null;
        public Vector3f globalPivot = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f pivot = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f rotation = null;
        public List<CubeDef> cubes = new ArrayList<CubeDef>();
    }

    public static class CubeDef {
        public Vector3f origin = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f size = new Vector3f(0.0f, 0.0f, 0.0f);
        public Float inflate = Float.valueOf(0.0f);
        public Vector2i uv = new Vector2i(0, 0);
    }

    public static class DescriptionDef {
        public int width = 32;
        public int height = 32;
    }
}

