/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morevillargers.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mcreator.morevillargers.MoreVillargersMod;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoreVillargersModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"more_villargers");
    public static final RegistryObject<VillagerProfession> BEEKEEPER = MoreVillargersModVillagerProfessions.registerProfession("beekeeper", () -> Blocks.f_50616_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.beehive.work")));
    public static final RegistryObject<VillagerProfession> MARINER = MoreVillargersModVillagerProfessions.registerProfession("mariner", () -> Blocks.f_50577_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambient.underwater.enter")));
    public static final RegistryObject<VillagerProfession> GARDENER = MoreVillargersModVillagerProfessions.registerProfession("gardener", () -> Blocks.f_50186_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.crop.plant")));
    public static final RegistryObject<VillagerProfession> WOODCUTTER = MoreVillargersModVillagerProfessions.registerProfession("woodcutter", () -> Blocks.f_49999_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.cherry_wood_door.close")));
    public static final RegistryObject<VillagerProfession> HUNTER = MoreVillargersModVillagerProfessions.registerProfession("hunter", () -> Blocks.f_50087_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.chest.close")));
    public static final RegistryObject<VillagerProfession> ARCHAEOLOGIST = MoreVillargersModVillagerProfessions.registerProfession("archaeologist", () -> Blocks.f_50064_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.sand.fall")));
    public static final RegistryObject<VillagerProfession> MUSICIAN = MoreVillargersModVillagerProfessions.registerProfession("musician", () -> Blocks.f_50065_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.note_block.banjo")));
    public static final RegistryObject<VillagerProfession> MECHANIC = MoreVillargersModVillagerProfessions.registerProfession("mechanic", () -> Blocks.f_50039_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.tnt.primed")));
    public static final RegistryObject<VillagerProfession> BAKER = MoreVillargersModVillagerProfessions.registerProfession("baker", () -> Blocks.f_50145_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.cake.add_candle")));
    public static final RegistryObject<VillagerProfession> PAINTER = MoreVillargersModVillagerProfessions.registerProfession("painter", () -> Blocks.f_50041_, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.bamboo_wood_button.click_off")));

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> MoreVillargersModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.get() == MoreVillargersModVillagerProfessions.POI_TYPES.get((Object)name).poiType.get();
            return new VillagerProfession("more_villargers:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.POI_TYPES, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.m_218075_((BlockState)block.m_49966_());
                if (existingCheck.isPresent()) {
                    MoreVillargersMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + block + " that is already in use by " + existingCheck);
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), 1, 1);
                registerHelper.register(name, (Object)poiType);
                entry.getValue().poiType = (Holder)ForgeRegistries.POI_TYPES.getHolder((Object)poiType).get();
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

