/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.screen.WildfireBreastCustomizationScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.config.BreastPresetConfiguration;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WildfireBreastPresetList
extends AbstractSelectionList<BreastPresetListEntry> {
    public boolean active = true;
    public boolean visible = true;
    private static final ResourceLocation TXTR_SYNC = WildfireGender.rl("textures/sync.png");
    private static final ResourceLocation TXTR_UNKNOWN = WildfireGender.rl("textures/unknown.png");
    private static final ResourceLocation TXTR_CACHED = WildfireGender.rl("textures/cached.png");
    private final WildfireBreastCustomizationScreen parent;
    private final int listWidth;
    private boolean hasPresets;

    public WildfireBreastPresetList(WildfireBreastCustomizationScreen parent, int listWidth, int top, int bottom) {
        super(Minecraft.m_91087_(), 156, parent.f_96544_, top, bottom, 32);
        this.m_93473_(false, 0);
        this.m_93488_(false);
        this.m_93496_(false);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    public boolean hasPresets() {
        return this.hasPresets;
    }

    protected void m_240140_(@Nonnull GuiGraphics context, int y, int entryWidth, int entryHeight, int borderColor, int fillColor) {
    }

    protected int m_7610_(int index) {
        return super.m_7610_(index) - 4;
    }

    protected int m_5756_() {
        return this.parent.f_96543_ / 2 + 181;
    }

    public int m_5759_() {
        return this.listWidth;
    }

    protected void m_93516_() {
        super.m_93516_();
        this.hasPresets = false;
    }

    public void refreshList() {
        BreastPresetConfiguration[] CONFIGS;
        this.m_93516_();
        if (this.f_93386_.f_91073_ == null || this.f_93386_.f_91074_ == null) {
            return;
        }
        for (BreastPresetConfiguration presetCfg : CONFIGS = BreastPresetConfiguration.getBreastPresetConfigurationFiles()) {
            this.m_7085_(new BreastPresetListEntry(presetCfg));
        }
        this.hasPresets = CONFIGS.length > 0;
    }

    public void m_142291_(@Nonnull NarrationElementOutput output) {
    }

    public class BreastPresetListEntry
    extends AbstractSelectionList.Entry<BreastPresetListEntry> {
        private final ResourceLocation thumbnail;
        private final String name;
        private final WildfireButton btnOpenGUI;

        private BreastPresetListEntry(BreastPresetConfiguration data) {
            this(WildfireGender.rl("textures/presets/iknowthisisnull.png"), data.get(BreastPresetConfiguration.PRESET_NAME), data);
            WildfireGender.logger.debug("Preset Name: {}", (Object)this.name);
        }

        private BreastPresetListEntry(ResourceLocation thumbnail, String name, BreastPresetConfiguration data) {
            this.name = name;
            this.thumbnail = thumbnail;
            this.btnOpenGUI = new WildfireButton(0, 0, WildfireBreastPresetList.this.m_5759_() - 6, WildfireBreastPresetList.this.f_93387_, (Component)Component.m_237119_(), button -> {
                GenderPlayer player = WildfireBreastPresetList.this.parent.getPlayer();
                player.updateBustSize(data);
                player.getBreasts().copyFrom(data);
            });
        }

        public void m_6311_(@Nonnull GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            if (!WildfireBreastPresetList.this.visible) {
                return;
            }
            Font font = Minecraft.m_91087_().f_91062_;
            graphics.m_280163_(this.thumbnail, x + 2, y + 2, 0.0f, 0.0f, 28, 28, 28, 28);
            graphics.m_280614_(font, (Component)Component.m_237113_((String)this.name), x + 34, y + 4, -1, false);
            this.btnOpenGUI.m_252865_(x);
            this.btnOpenGUI.m_253211_(y);
            this.btnOpenGUI.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (WildfireBreastPresetList.this.active && WildfireBreastPresetList.this.visible) {
                if (this.btnOpenGUI.m_6375_(mouseX, mouseY, button)) {
                    return true;
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
            return false;
        }
    }
}

