/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.ThreeLayerNoisySphereReplaceConfig;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util.NoisySphereUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ThreeLayerNoisySphereReplaceFeature
extends Feature<ThreeLayerNoisySphereReplaceConfig> {
    private static final double NOISE_FREQUENCY_XZ = 0.15;
    private static final double NOISE_FREQUENCY_Y = 0.15;
    private static final long NOISE_SEED_FLIP_MASK = -7005860059682304583L;

    public ThreeLayerNoisySphereReplaceFeature(Codec<ThreeLayerNoisySphereReplaceConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ThreeLayerNoisySphereReplaceConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        int radiusMin = ((ThreeLayerNoisySphereReplaceConfig)context.m_159778_()).radiusMin;
        int radiusMax = ((ThreeLayerNoisySphereReplaceConfig)context.m_159778_()).radiusMax;
        List<Block> matches = ((ThreeLayerNoisySphereReplaceConfig)context.m_159778_()).matches;
        long noiseSeed = context.m_159774_().m_7328_() ^ 0x9EC62F64F48A0DB9L;
        BlockState floor = ((ThreeLayerNoisySphereReplaceConfig)context.m_159778_()).floor.orElse(null);
        BlockState ceiling = ((ThreeLayerNoisySphereReplaceConfig)context.m_159778_()).ceiling.orElse(null);
        int floorWidth = ((ThreeLayerNoisySphereReplaceConfig)context.m_159778_()).floorWidth;
        int ceilingWidth = ((ThreeLayerNoisySphereReplaceConfig)context.m_159778_()).ceilingWidth;
        for (BlockPos here : new NoisySphereUtils.NoisySphereIterable(origin, noiseSeed, 0.15, 0.15, radiusMin, radiusMax)) {
            int yOffset;
            if (!matches.contains(level.m_8055_(here).m_60734_())) continue;
            boolean placed = false;
            if (floor != null) {
                for (yOffset = 1; yOffset <= floorWidth; ++yOffset) {
                    if (!level.m_8055_(here.m_6630_(yOffset)).m_60795_()) continue;
                    level.m_7731_(here, floor, 3);
                    placed = true;
                    break;
                }
            }
            if (!placed && ceiling != null) {
                for (yOffset = 1; yOffset <= ceilingWidth; ++yOffset) {
                    if (!level.m_8055_(here.m_6625_(yOffset)).m_60795_()) continue;
                    level.m_7731_(here, ceiling, 3);
                    placed = true;
                    break;
                }
            }
            if (placed) continue;
            level.m_7731_(here, ((ThreeLayerNoisySphereReplaceConfig)context.m_159778_()).regular, 3);
        }
        return true;
    }
}

