/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.network;

import com.yungnickyoung.minecraft.yungscavebiomes.network.ClientPacketHandler;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SandstormSyncS2CPacket {
    private final boolean isActive;
    private final int currSandstormTicks;
    private final long sandstormSeed;
    private final int totalSandstormDurationTicks;

    public SandstormSyncS2CPacket(SandstormServerData sandstormServerData) {
        this.isActive = sandstormServerData.isSandstormActive();
        this.currSandstormTicks = sandstormServerData.getCurrSandstormTicks();
        this.sandstormSeed = sandstormServerData.getSeed();
        this.totalSandstormDurationTicks = sandstormServerData.getTotalSandstormDurationTicks();
    }

    public SandstormSyncS2CPacket(FriendlyByteBuf buf) {
        this.isActive = buf.readBoolean();
        this.currSandstormTicks = buf.readInt();
        this.sandstormSeed = buf.readLong();
        this.totalSandstormDurationTicks = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isActive);
        buf.writeInt(this.currSandstormTicks);
        buf.writeLong(this.sandstormSeed);
        buf.writeInt(this.totalSandstormDurationTicks);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)ctx)));
        ctx.get().setPacketHandled(true);
        return true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getCurrSandstormTicks() {
        return this.currSandstormTicks;
    }

    public long getSandstormSeed() {
        return this.sandstormSeed;
    }

    public int getTotalSandstormDurationTicks() {
        return this.totalSandstormDurationTicks;
    }

    private /* synthetic */ Runnable lambda$handle$1(Supplier ctx) {
        return () -> this.lambda$handle$0((Supplier)ctx);
    }

    private /* synthetic */ void lambda$handle$0(Supplier ctx) {
        ClientPacketHandler.handleSandstormSync(this, ctx);
    }
}

