/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.obscuria.caravans.content.caravan.CaravanSpawner;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import dev.obscuria.caravans.mixin.ResourceKeyArgumentAccessor;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class CaravanCommand {
    private static final DynamicCommandExceptionType ERR_INVALID_VARIATION = new DynamicCommandExceptionType(it -> Component.m_237110_((String)"commands.caravan.spawn.invalid", (Object[])new Object[]{it}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"caravan").requires(it -> it.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cooldown").then(Commands.m_82127_((String)"get").executes(it -> CaravanCommand.getCooldown((CommandSourceStack)it.getSource())))).then(Commands.m_82127_((String)"reset").executes(it -> CaravanCommand.resetCooldown((CommandSourceStack)it.getSource())))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(it -> CaravanCommand.setCooldown((CommandSourceStack)it.getSource(), IntegerArgumentType.getInteger((CommandContext)it, (String)"ticks"))))))).then(Commands.m_82127_((String)"spawn").then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"variation", (ArgumentType)ResourceKeyArgument.m_212386_(CaravanRegistries.Keys.VARIATION)).executes(it -> CaravanCommand.spawn((CommandSourceStack)it.getSource(), BlockPosArgument.m_264582_((CommandContext)it, (String)"position"), CaravanCommand.getCaravansVariation((CommandContext<CommandSourceStack>)it, "variation")))))));
    }

    public static int getCooldown(CommandSourceStack source) {
        int ticks = CaravanSpawner.INSTANCE.cooldownTick;
        source.m_288197_(() -> Component.m_237110_((String)"commands.caravan.cooldown.get", (Object[])new Object[]{ticks}), false);
        return ticks;
    }

    public static int resetCooldown(CommandSourceStack source) {
        CaravanSpawner.INSTANCE.cooldownTick = 0;
        source.m_288197_(() -> Component.m_237115_((String)"commands.caravan.cooldown.reset"), true);
        return 1;
    }

    public static int setCooldown(CommandSourceStack source, int ticks) {
        CaravanSpawner.INSTANCE.cooldownTick = ticks;
        source.m_288197_(() -> Component.m_237110_((String)"commands.caravan.cooldown.set", (Object[])new Object[]{ticks}), true);
        return 1;
    }

    private static int spawn(CommandSourceStack source, BlockPos pos, Holder.Reference<CaravanVariation> variation) {
        ResourceLocation id = variation.m_205785_().m_135782_();
        source.m_288197_(() -> Component.m_237110_((String)"commands.caravan.spawn.success", (Object[])new Object[]{id, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
        return ((CaravanVariation)variation.m_203334_()).spawn((Holder<CaravanVariation>)variation, source.m_81372_(), pos);
    }

    private static Holder.Reference<CaravanVariation> getCaravansVariation(CommandContext<CommandSourceStack> context, String name) {
        return ResourceKeyArgumentAccessor.invokeResolveKey(context, name, CaravanRegistries.Keys.VARIATION, ERR_INVALID_VARIATION);
    }
}

