/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content;

import com.google.common.collect.ImmutableList;
import dev.obscuria.caravans.config.CommonConfig;
import dev.obscuria.caravans.content.ILivingExtension;
import dev.obscuria.caravans.content.caravan.CaravanSpawner;
import dev.obscuria.caravans.content.network.ClientboundEncounterPayload;
import dev.obscuria.fragmentum.network.FragmentumNetworking;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.CustomSpawner;

public interface Hooks {
    public static ImmutableList<CustomSpawner> injectSpawners(List<CustomSpawner> spawners) {
        return ImmutableList.builder().addAll(spawners).add((Object)CaravanSpawner.INSTANCE).build();
    }

    public static void onLivingTick(LivingEntity entity) {
        if (!((Boolean)CommonConfig.SHOW_ENCOUNTER_TOAST.get()).booleanValue()) {
            return;
        }
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.f_19797_ % 40 != 0) {
            return;
        }
        ResourceLocation caravanType = ILivingExtension.getCaravanType(entity);
        if (caravanType == null) {
            return;
        }
        List<UUID> playerTracker = ILivingExtension.playerTracker(entity);
        List players = entity.m_9236_().m_45976_(ServerPlayer.class, entity.m_20191_().m_82400_(32.0));
        if (players.isEmpty()) {
            return;
        }
        for (ServerPlayer player : players) {
            if (playerTracker.contains(player.m_20148_())) continue;
            FragmentumNetworking.sendTo((ServerPlayer)player, (Object)ClientboundEncounterPayload.forCaravan(caravanType));
            playerTracker.add(player.m_20148_());
        }
    }

    public static void onLeashTick(Mob mob) {
        LivingEntity living;
        Entity holder = mob.m_21524_();
        if (holder == null || !holder.m_213877_()) {
            return;
        }
        if (holder.m_146911_() != Entity.RemovalReason.DISCARDED) {
            return;
        }
        if (!(holder instanceof LivingEntity) || !ILivingExtension.isCaravanMember(living = (LivingEntity)holder)) {
            return;
        }
        mob.m_21455_(false, false);
        mob.m_146870_();
    }
}

