/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;

public class BetterCavesWorldCarverConfig
extends CarverConfiguration {
    public static final Codec<BetterCavesWorldCarverConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CaveLayerSettings.CODEC.listOf().fieldOf("cave_layers").forGetter(config -> config.caveLayers), (App)CavernLayerSettings.CODEC.listOf().fieldOf("cavern_layers").forGetter(config -> config.cavernLayers), (App)MiscSettings.CODEC.fieldOf("misc").forGetter(config -> config.misc), (App)DebugSettings.CODEC.optionalFieldOf("debug_settings", (Object)DebugSettings.DEFAULT).forGetter(config -> config.debugSettings)).apply((Applicative)builder, BetterCavesWorldCarverConfig::new));
    public final List<CaveLayerSettings> caveLayers;
    public final List<CavernLayerSettings> cavernLayers;
    public final MiscSettings misc;
    public final DebugSettings debugSettings;

    public BetterCavesWorldCarverConfig(List<CaveLayerSettings> caveLayers, List<CavernLayerSettings> cavernLayers, MiscSettings misc, DebugSettings debugSettings) {
        super(1.0f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)180)), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)0.9f), VerticalAnchor.m_158930_((int)8), CarverDebugSettings.f_159114_, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)Blocks.f_50069_)}));
        this.caveLayers = caveLayers;
        this.cavernLayers = cavernLayers;
        this.misc = misc;
        this.debugSettings = debugSettings;
    }

    public record MiscSettings(HolderSet<Block> replaceable, boolean overrideSurfaceDetection) {
        public static final Codec<MiscSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("replaceable").forGetter(MiscSettings::replaceable), (App)Codec.BOOL.optionalFieldOf("override_surface_detection", (Object)false).forGetter(MiscSettings::overrideSurfaceDetection)).apply((Applicative)builder, MiscSettings::new));
    }

    public record DebugSettings(boolean enabled, int topY) {
        public static final DebugSettings DEFAULT = new DebugSettings(false, 128);
        public static final Codec<DebugSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)false).forGetter(DebugSettings::enabled), (App)Codec.INT.fieldOf("top_y").forGetter(DebugSettings::topY)).apply((Applicative)builder, DebugSettings::new));
    }

    public record CaveLayerSettings(List<CaveSubCarverSettings> carvers, double caveSpawnChance, double caveRegionSizeFrequency) {
        public static final Codec<CaveLayerSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CaveSubCarverSettings.CODEC.listOf().fieldOf("carvers").forGetter(config -> config.carvers), (App)Codec.DOUBLE.fieldOf("cave_spawn_chance").forGetter(config -> config.caveSpawnChance), (App)Codec.DOUBLE.fieldOf("cave_region_size_frequency").forGetter(config -> config.caveRegionSizeFrequency)).apply((Applicative)builder, CaveLayerSettings::new));

        public record CaveSubCarverSettings(int bottomY, int topY, int surfaceCutoffDistance, double yCompression, double xzCompression, int spawnWeight, BlockState debugCarveState, Advanced advanced) {
            public static final Codec<CaveSubCarverSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("bottom_y").forGetter(CaveSubCarverSettings::bottomY), (App)Codec.INT.fieldOf("top_y").forGetter(CaveSubCarverSettings::topY), (App)Codec.INT.fieldOf("surface_cutoff_distance").forGetter(CaveSubCarverSettings::surfaceCutoffDistance), (App)Codec.DOUBLE.fieldOf("y_compression").forGetter(CaveSubCarverSettings::yCompression), (App)Codec.DOUBLE.fieldOf("xz_compression").forGetter(CaveSubCarverSettings::xzCompression), (App)Codec.INT.fieldOf("spawn_weight").forGetter(CaveSubCarverSettings::spawnWeight), (App)BlockState.f_61039_.optionalFieldOf("debug_carve_state", (Object)Blocks.f_50705_.m_49966_()).forGetter(CaveSubCarverSettings::debugCarveState), (App)Advanced.CODEC.fieldOf("advanced").forGetter(CaveSubCarverSettings::advanced)).apply((Applicative)builder, CaveSubCarverSettings::new));

            public record Advanced(double noiseThreshold, int fractalOctaves, double fractalGain, double fractalFrequency, int numGenerators, boolean yAdjust, double yAdjustF1, double yAdjustF2, String noiseType, boolean isFastNoise) {
                public static final Codec<Advanced> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.fieldOf("noise_threshold").forGetter(Advanced::noiseThreshold), (App)Codec.INT.fieldOf("fractal_octaves").forGetter(Advanced::fractalOctaves), (App)Codec.DOUBLE.fieldOf("fractal_gain").forGetter(Advanced::fractalGain), (App)Codec.DOUBLE.fieldOf("fractal_frequency").forGetter(Advanced::fractalFrequency), (App)Codec.INT.fieldOf("num_generators").forGetter(Advanced::numGenerators), (App)Codec.BOOL.fieldOf("y_adjust").forGetter(Advanced::yAdjust), (App)Codec.DOUBLE.fieldOf("y_adjust_f1").forGetter(Advanced::yAdjustF1), (App)Codec.DOUBLE.fieldOf("y_adjust_f2").forGetter(Advanced::yAdjustF2), (App)Codec.STRING.fieldOf("noise_type").forGetter(Advanced::noiseType), (App)Codec.BOOL.fieldOf("is_fast_noise").forGetter(Advanced::isFastNoise)).apply((Applicative)builder, Advanced::new));
            }
        }
    }

    public record CavernLayerSettings(List<CavernSubCarverSettings> carvers, double cavernSpawnChance, double cavernRegionSizeFrequency) {
        public static final Codec<CavernLayerSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CavernSubCarverSettings.CODEC.listOf().fieldOf("carvers").forGetter(CavernLayerSettings::carvers), (App)Codec.DOUBLE.fieldOf("cavern_spawn_chance").forGetter(CavernLayerSettings::cavernSpawnChance), (App)Codec.DOUBLE.fieldOf("cavern_region_size_frequency").forGetter(CavernLayerSettings::cavernRegionSizeFrequency)).apply((Applicative)builder, CavernLayerSettings::new));

        public record CavernSubCarverSettings(int bottomY, int topY, double yCompression, double xzCompression, int spawnWeight, boolean isFloored, BlockState debugCarveState, Advanced advanced) {
            public static final Codec<CavernSubCarverSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("bottom_y").forGetter(CavernSubCarverSettings::bottomY), (App)Codec.INT.fieldOf("top_y").forGetter(CavernSubCarverSettings::topY), (App)Codec.DOUBLE.fieldOf("y_compression").forGetter(CavernSubCarverSettings::yCompression), (App)Codec.DOUBLE.fieldOf("xz_compression").forGetter(CavernSubCarverSettings::xzCompression), (App)Codec.INT.fieldOf("spawn_weight").forGetter(CavernSubCarverSettings::spawnWeight), (App)Codec.BOOL.fieldOf("is_floored").forGetter(CavernSubCarverSettings::isFloored), (App)BlockState.f_61039_.optionalFieldOf("debug_carve_state", (Object)Blocks.f_50705_.m_49966_()).forGetter(CavernSubCarverSettings::debugCarveState), (App)Advanced.CODEC.fieldOf("advanced").forGetter(CavernSubCarverSettings::advanced)).apply((Applicative)builder, CavernSubCarverSettings::new));

            public record Advanced(double noiseThreshold, int fractalOctaves, double fractalGain, double fractalFrequency, int numGenerators, String noiseType, boolean isFastNoise) {
                public static final Codec<Advanced> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.fieldOf("noise_threshold").forGetter(Advanced::noiseThreshold), (App)Codec.INT.fieldOf("fractal_octaves").forGetter(Advanced::fractalOctaves), (App)Codec.DOUBLE.fieldOf("fractal_gain").forGetter(Advanced::fractalGain), (App)Codec.DOUBLE.fieldOf("fractal_frequency").forGetter(Advanced::fractalFrequency), (App)Codec.INT.fieldOf("num_generators").forGetter(Advanced::numGenerators), (App)Codec.STRING.fieldOf("noise_type").forGetter(Advanced::noiseType), (App)Codec.BOOL.fieldOf("is_fast_noise").forGetter(Advanced::isFastNoise)).apply((Applicative)builder, Advanced::new));
            }
        }
    }
}

