/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.util.screenshakeutil;

import java.util.Random;

public class CameraMomentum {
    private static float currentYawOffset = 0.0f;
    private static float currentPitchOffset = 0.0f;
    private static float targetYawOffset = 0.0f;
    private static float targetPitchOffset = 0.0f;
    private static float yawVelocity = 0.0f;
    private static float pitchVelocity = 0.0f;
    private static final float MOMENTUM_STIFFNESS = 0.1f;
    private static final float MOMENTUM_DAMPING = 0.1f;
    private static final float MOMENTUM_MASS = 0.5f;
    private static final float MAX_MOMENTUM_OFFSET = 360.0f;
    private static float shakeYawOffset = 0.0f;
    private static float shakePitchOffset = 0.0f;
    private static float shakeYawVelocity = 0.0f;
    private static float shakePitchVelocity = 0.0f;
    private static final float SHAKE_STIFFNESS = 0.5f;
    private static final float SHAKE_DAMPING = 0.9f;
    private static final float SHAKE_MASS = 0.4f;
    private static float shakeIntensity = 0.0f;
    private static final float MAX_SHAKE_INTENSITY = 4.0f;
    private static final float SHAKE_DECAY_RATE = 0.15f;
    private static Random random = new Random();

    public static void triggerSwing(float yawForce, float pitchForce, float shakeAmount) {
        targetYawOffset = CameraMomentum.clamp(targetYawOffset + yawForce, -360.0f, 360.0f);
        targetPitchOffset = CameraMomentum.clamp(targetPitchOffset + pitchForce, -360.0f, 360.0f);
        yawVelocity += yawForce * 0.5f;
        pitchVelocity += pitchForce * 0.5f;
        if (shakeAmount > 0.0f) {
            shakeIntensity = Math.min(shakeIntensity + shakeAmount, 4.0f);
            float randomYaw = (random.nextFloat() - 0.5f) * 2.0f * shakeIntensity;
            float randomPitch = (random.nextFloat() - 0.5f) * 2.0f * shakeIntensity * 0.7f;
            shakeYawVelocity += randomYaw;
            shakePitchVelocity += randomPitch;
        }
    }

    public static void triggerSwing(float yawForce, float pitchForce) {
        CameraMomentum.triggerSwing(yawForce, pitchForce, 0.0f);
    }

    public static void update() {
        float yawAcceleration = (targetYawOffset - currentYawOffset) * 0.1f / 0.5f;
        float pitchAcceleration = (targetPitchOffset - currentPitchOffset) * 0.1f / 0.5f;
        yawVelocity = (yawVelocity + yawAcceleration) * 0.1f;
        pitchVelocity = (pitchVelocity + pitchAcceleration) * 0.1f;
        currentYawOffset += yawVelocity;
        currentPitchOffset += pitchVelocity;
        targetYawOffset *= 0.95f;
        targetPitchOffset *= 0.95f;
        if (shakeIntensity > 0.0f) {
            float shakeYawAccel = -shakeYawOffset * 0.5f / 0.4f;
            float shakePitchAccel = -shakePitchOffset * 0.5f / 0.4f;
            shakeYawVelocity = (shakeYawVelocity + shakeYawAccel) * 0.9f;
            shakePitchVelocity = (shakePitchVelocity + shakePitchAccel) * 0.9f;
            shakeYawOffset += shakeYawVelocity;
            shakePitchOffset += shakePitchVelocity;
            if ((shakeIntensity = Math.max(0.0f, shakeIntensity - 0.15f)) < 0.1f) {
                shakeYawOffset = 0.0f;
                shakePitchOffset = 0.0f;
                shakeYawVelocity = 0.0f;
                shakePitchVelocity = 0.0f;
                shakeIntensity = 0.0f;
            }
        }
    }

    public static float getTotalYawOffset() {
        return CameraMomentum.clamp(currentYawOffset + shakeYawOffset, -25.0f, 25.0f);
    }

    public static float getTotalPitchOffset() {
        return CameraMomentum.clamp(currentPitchOffset + shakePitchOffset, -15.0f, 15.0f);
    }

    private static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }
}

