/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.fluid;

import cn.mcmod_mmf.mmlib.utils.DataGenUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidHelper {
    public static JsonElement serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + id + "'");
        }
        int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        FluidStack stack = new FluidStack(fluid, amount);
        if (!json.has("nbt")) {
            return stack;
        }
        try {
            JsonElement element = json.get("nbt");
            stack.setTag(TagParser.m_129359_((String)(element.isJsonObject() ? DataGenUtil.DATA_GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return stack;
    }
}

