/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client.compat.ar;

import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockCube;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockPart;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockPolygon;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockVertex;
import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.util.FastColor;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BedrockPart.class})
public class AcceleratedBedrockPart
implements IAcceleratedRenderer<Void> {
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();

    @Inject(method={"compile"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void compile(PoseStack.Pose pPose, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated((VertexConsumer)pBuffer);
        if (AcceleratedEntityRenderingFeature.isEnabled() && AcceleratedEntityRenderingFeature.shouldUseAcceleratedPipeline() && (CoreFeature.isRenderingLevel() || CoreFeature.isRenderingGui() && AcceleratedEntityRenderingFeature.shouldAccelerateInGui()) && extension.isAccelerated()) {
            ci.cancel();
            extension.doRender((IAcceleratedRenderer)this, null, pPose.m_252922_(), pPose.m_252943_(), pPackedLight, pPackedOverlay, FastColor.ARGB32.m_13660_((int)((int)(alpha * 255.0f)), (int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f))));
        }
    }

    @Unique
    public void render(VertexConsumer vertexConsumer, Void context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated((VertexConsumer)vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        VertexConsumer meshBuilder = extension.decorate((VertexConsumer)culledMeshCollector);
        BedrockPart part = (BedrockPart)((Object)this);
        for (BedrockCube cube : part.getCubes()) {
            for (BedrockPolygon polygon : cube.getPolygons()) {
                Vector3f polygonNormal = polygon.normal;
                for (BedrockVertex vertex : polygon.vertices) {
                    Vector3f vertexPosition = vertex.pos;
                    meshBuilder.m_5954_(vertexPosition.x, vertexPosition.y, vertexPosition.z, 1.0f, 1.0f, 1.0f, 1.0f, vertex.u, vertex.v, overlay, 0, polygonNormal.x, polygonNormal.y, polygonNormal.z);
                }
            }
        }
        culledMeshCollector.flush();
        mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build((IMeshCollector)culledMeshCollector);
        this.meshes.put((IBufferGraph)extension, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

