/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;

public final class PacketSplitter {
    public static final byte STATE_FIRST = 1;
    public static final byte STATE_LAST = 2;
    private final int partSize;
    private final List<byte[]> receivedBuffers = new ArrayList<byte[]>();

    public PacketSplitter(int partSize) {
        if (partSize <= 0) {
            throw new IllegalArgumentException("partSize must be > 0");
        }
        this.partSize = partSize;
    }

    public void splitAndSend(byte[] fullStream, Consumer<byte[]> sendPayloadSlice) {
        if (fullStream.length <= this.partSize) {
            byte[] payloadSlice = new byte[fullStream.length + 1];
            payloadSlice[0] = 2;
            System.arraycopy(fullStream, 0, payloadSlice, 1, fullStream.length);
            sendPayloadSlice.accept(payloadSlice);
            return;
        }
        int parts = (int)Math.ceil((double)fullStream.length / (double)this.partSize);
        for (int part = 0; part < parts; ++part) {
            int start = part * this.partSize;
            int size = Math.min(this.partSize, fullStream.length - start);
            int state = part == 0 ? 1 : (part == parts - 1 ? 2 : 0);
            byte[] payloadSlice = new byte[size + 1];
            payloadSlice[0] = state;
            System.arraycopy(fullStream, start, payloadSlice, 1, size);
            sendPayloadSlice.accept(payloadSlice);
        }
    }

    @Nullable
    public FriendlyByteBuf acceptPart(@Nullable byte[] payloadSlice) {
        if (payloadSlice == null || payloadSlice.length == 0) {
            this.reset();
            return null;
        }
        byte state = payloadSlice[0];
        if (state == 1 && !this.receivedBuffers.isEmpty()) {
            this.receivedBuffers.clear();
        }
        int contentSize = payloadSlice.length - 1;
        byte[] content = new byte[contentSize];
        if (contentSize > 0) {
            System.arraycopy(payloadSlice, 1, content, 0, contentSize);
        }
        this.receivedBuffers.add(content);
        if (state == 2) {
            byte[][] buffers = (byte[][])this.receivedBuffers.toArray((T[])new byte[0][]);
            this.receivedBuffers.clear();
            return new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[][])buffers));
        }
        return null;
    }

    public void reset() {
        this.receivedBuffers.clear();
    }
}

