/*
 * Decompiled with CFR 0.152.
 */
package dev.bsmp.emotetweaks.voicefx;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import dev.architectury.networking.NetworkManager;
import dev.bsmp.emotetweaks.emotetweaks.EmoteTweaksMain;
import dev.bsmp.emotetweaks.voicefx.SoundPlugin;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SFXThread
extends Thread {
    private final OpusEncoder encoder;
    private final UUID uuid;
    private boolean started;
    private AudioInputStream stream;

    private SFXThread(UUID uuid, OpusEncoder encoder, AudioInputStream stream) {
        this.uuid = uuid;
        this.encoder = encoder;
        this.stream = stream;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        int framePosition = 0;
        long startTime = System.nanoTime();
        try {
            byte[] bytes = new byte[1920];
            while (this.stream.read(bytes) != -1 && !this.isInterrupted()) {
                short[] frame = SoundPlugin.voicechatApi.getAudioConverter().bytesToShorts(bytes);
                bytes = new byte[1920];
                if (frame.length != 960) {
                    Voicechat.LOGGER.error("Got invalid audio frame size {}!={}", (Object)frame.length, (Object)960);
                    break;
                }
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130077_(this.uuid);
                buf.m_130087_(this.encoder.encode(frame));
                buf.writeLong((long)framePosition);
                NetworkManager.sendToServer((ResourceLocation)EmoteTweaksMain.PACKET_ID, (FriendlyByteBuf)buf);
                short[] finalFrame = frame;
                Minecraft.m_91087_().execute(() -> ClientManager.getClient().processSoundPacket((SoundPacket)new LocationSoundPacket(this.uuid, finalFrame, Minecraft.m_91087_().f_91074_.m_20182_(), 15.0f, null)));
                long waitTimestamp = startTime + (long)(++framePosition) * 20000000L;
                long waitNanos = waitTimestamp - System.nanoTime();
                try {
                    if (waitNanos <= 0L) continue;
                    Thread.sleep(waitNanos / 1000000L, (int)(waitNanos % 1000000L));
                }
                catch (InterruptedException var10) {
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.encoder.close();
    }

    public void startPlaying() {
        if (!this.started) {
            this.start();
            this.started = true;
        }
    }

    public static SFXThread playSFX(AudioInputStream stream) throws UnsupportedAudioFileException, IOException {
        return new SFXThread(UUID.randomUUID(), SoundPlugin.voicechatApi.createEncoder(), stream);
    }
}

