/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.merchantpug.apugli.access.ExplosionAccess;
import net.merchantpug.apugli.network.s2c.SyncExplosionPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ActiveCooldownPowerFactory;
import net.merchantpug.apugli.registry.ApugliTags;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@Deprecated
public interface RocketJumpPowerFactory<P>
extends ActiveCooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ActiveCooldownPowerFactory.getSerializableData().add("distance", SerializableDataTypes.DOUBLE, (Object)Double.NaN).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, null).add("source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null).add("amount", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("velocity", SerializableDataTypes.DOUBLE, (Object)1.0).addFunctionedDefault("horizontal_velocity", SerializableDataTypes.DOUBLE, data -> data.getDouble("velocity")).addFunctionedDefault("vertical_velocity", SerializableDataTypes.DOUBLE, data -> data.getDouble("velocity")).add("velocity_clamp_multiplier", SerializableDataTypes.DOUBLE, (Object)1.8).add("use_charged", SerializableDataTypes.BOOLEAN, (Object)false).add("charged_modifier", Services.PLATFORM.getModifierDataType(), null).add("charged_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("water_modifier", Services.PLATFORM.getModifierDataType(), null).add("water_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("damage_modifier", Services.PLATFORM.getModifierDataType(), null).add("damage_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("targetable_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("damage_bientity_condition", Services.CONDITION.biEntityDataType(), null);
    }

    public List<?> chargedModifiers(P var1, Entity var2);

    public List<?> waterModifiers(P var1, Entity var2);

    public List<?> damageModifiers(P var1, Entity var2);

    public List<?> knockbackModifiers();

    public List<?> volumeModifiers();

    public List<?> pitchModifiers();

    default public void executeJump(P power, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!entity.m_9236_().m_5776_()) {
                HitResult.Type entityHitResultType;
                SerializableData.Instance data = this.getDataFromPower(power);
                double distance = !Double.isNaN(data.getDouble("distance")) ? data.getDouble("distance") : Services.PLATFORM.getReachDistance(entity);
                Vec3 eyePosition = entity.m_20299_(0.0f);
                Vec3 lookVector = entity.m_20252_(0.0f).m_82490_(distance);
                Vec3 traceEnd = eyePosition.m_82549_(lookVector);
                ClipContext context = new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity);
                BlockHitResult blockHitResult = entity.m_9236_().m_45547_(context);
                double entityDistance = !Double.isNaN(data.getDouble("distance")) ? data.getDouble("distance") : Services.PLATFORM.getAttackRange(entity);
                Vec3 entityLookVector = entity.m_20252_(0.0f).m_82490_(entityDistance);
                Vec3 entityTraceEnd = eyePosition.m_82549_(entityLookVector);
                AABB entityBox = entity.m_20191_().m_82369_(lookVector).m_82400_(1.0);
                double blockHitResultSquaredDistance = blockHitResult.m_82425_().m_203198_(eyePosition.f_82479_, eyePosition.f_82480_, eyePosition.f_82481_);
                double entityReach = Math.min(blockHitResultSquaredDistance, entityDistance * entityDistance);
                EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)eyePosition, (Vec3)entityTraceEnd, (AABB)entityBox, traceEntity -> !traceEntity.m_5833_() && traceEntity.m_5829_() && Services.CONDITION.checkBiEntity(data, "targetable_bientity_condition", entity, (Entity)traceEntity), (double)entityReach);
                HitResult.Type blockHitResultType = blockHitResult.m_6662_();
                HitResult.Type type = entityHitResultType = entityHitResult != null ? entityHitResult.m_6662_() : HitResult.Type.MISS;
                if (blockHitResultType == HitResult.Type.MISS && entityHitResultType == HitResult.Type.MISS) {
                    return;
                }
                boolean isCharged = living.m_21220_().stream().anyMatch(effect -> BuiltInRegistries.f_256974_.m_7854_((Object)effect.m_19544_()).isPresent() && BuiltInRegistries.f_256974_.m_203636_((ResourceKey)BuiltInRegistries.f_256974_.m_7854_((Object)effect.m_19544_()).get()).isPresent() && ((Holder.Reference)BuiltInRegistries.f_256974_.m_203636_((ResourceKey)BuiltInRegistries.f_256974_.m_7854_((Object)effect.m_19544_()).get()).get()).m_203656_(ApugliTags.CHARGED_EFFECTS));
                if (entityHitResultType == HitResult.Type.ENTITY) {
                    this.handleRocketJump(power, data, living, (HitResult)entityHitResult, isCharged);
                    return;
                }
                if (blockHitResultType == HitResult.Type.BLOCK) {
                    this.handleRocketJump(power, data, living, (HitResult)blockHitResult, isCharged);
                }
            }
        }
    }

    default public void handleRocketJump(P power, SerializableData.Instance data, LivingEntity entity, HitResult hitResult, boolean isCharged) {
        float e;
        boolean useCharged = data.getBoolean("use_charged");
        double horizontalVelocity = isCharged && useCharged && !this.chargedModifiers(power, (Entity)entity).isEmpty() ? Services.PLATFORM.applyModifiers((Entity)entity, this.chargedModifiers(power, (Entity)entity), data.getDouble("horizontal_velocity")) : data.getDouble("horizontal_velocity");
        double verticalVelocity = isCharged && useCharged && !this.chargedModifiers(power, (Entity)entity).isEmpty() ? Services.PLATFORM.applyModifiers((Entity)entity, this.chargedModifiers(power, (Entity)entity), data.getDouble("vertical_velocity")) : data.getDouble("vertical_velocity");
        float f = e = isCharged && useCharged ? 2.0f : 1.5f;
        if ((data.isPresent("damage_type") || data.isPresent("source")) && data.getFloat("amount") != 0.0f) {
            DamageSource source = Services.PLATFORM.createDamageSource(entity.m_269291_(), data, "source", "damage_type");
            entity.m_6469_(source, data.getFloat("amount"));
        }
        float f2 = Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(entity.m_146909_() * ((float)Math.PI / 180)));
        float g = Mth.m_14031_((float)(entity.m_146909_() * ((float)Math.PI / 180)));
        float h = -Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(entity.m_146909_() * ((float)Math.PI / 180)));
        Explosion explosion = new Explosion(entity.m_9236_(), (Entity)entity, null, null, hitResult.m_82450_().m_7096_(), hitResult.m_82450_().m_7098_(), hitResult.m_82450_().m_7094_(), e, false, Explosion.BlockInteraction.KEEP);
        ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.damageModifiers(power, (Entity)entity));
        ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.knockbackModifiers());
        ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.volumeModifiers());
        ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.pitchModifiers());
        ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("damage_bientity_condition"));
        explosion.m_46061_();
        explosion.m_46075_(false);
        this.sendExplosionToClient(power, data, entity, hitResult, e);
        if (entity.m_20069_()) {
            horizontalVelocity = !this.waterModifiers(power, (Entity)entity).isEmpty() ? Services.PLATFORM.applyModifiers((Entity)entity, this.waterModifiers(power, (Entity)entity), horizontalVelocity) : horizontalVelocity;
            verticalVelocity = !this.waterModifiers(power, (Entity)entity).isEmpty() ? Services.PLATFORM.applyModifiers((Entity)entity, this.waterModifiers(power, (Entity)entity), verticalVelocity) : verticalVelocity;
        }
        double velocityClampMultiplier = data.getDouble("velocity_clamp_multiplier");
        Vec3 vec = entity.m_20184_().m_82520_((double)f2 * horizontalVelocity, (double)g * verticalVelocity, (double)h * horizontalVelocity);
        double horizontalClamp = isCharged ? Services.PLATFORM.applyModifiers((Entity)entity, this.chargedModifiers(power, (Entity)entity), horizontalVelocity * velocityClampMultiplier) : horizontalVelocity * velocityClampMultiplier;
        double verticalClamp = isCharged ? Services.PLATFORM.applyModifiers((Entity)entity, this.chargedModifiers(power, (Entity)entity), verticalVelocity * velocityClampMultiplier) : verticalVelocity * velocityClampMultiplier;
        entity.m_20334_(Mth.m_14008_((double)vec.f_82479_, (double)(-horizontalClamp), (double)horizontalClamp), Mth.m_14008_((double)vec.f_82480_, (double)(-verticalClamp), (double)verticalClamp), Mth.m_14008_((double)vec.f_82481_, (double)(-horizontalClamp), (double)horizontalClamp));
        entity.f_19864_ = true;
        entity.f_19789_ = 0.0f;
        this.use(power, (Entity)entity);
    }

    default public void sendExplosionToClient(P power, SerializableData.Instance data, LivingEntity entity, HitResult hitResult, float radius) {
        SyncExplosionPacket<Object, Object> packet = new SyncExplosionPacket<Object, Object>(entity.m_19879_(), hitResult.m_82450_().m_7096_(), hitResult.m_82450_().m_7098_(), hitResult.m_82450_().m_7094_(), this.damageModifiers(power, (Entity)entity), this.knockbackModifiers(), this.volumeModifiers(), this.pitchModifiers(), data.get("damage_bientity_condition"), false, null, false, radius);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Services.PLATFORM.sendS2CTrackingAndSelf(packet, (Entity)serverPlayer);
        }
    }
}

