/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Locale;
import javax.annotation.Nullable;
import net.merchantpug.apugli.Apugli;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public abstract class TextureOrUrlPower
extends Power {
    protected final ResourceLocation textureLocation;
    protected final String textureUrl;

    public TextureOrUrlPower(PowerType<?> type, LivingEntity entity, ResourceLocation textureLocation, String textureUrl) {
        super(type, entity);
        this.textureLocation = textureLocation;
        this.textureUrl = textureUrl;
        if (textureLocation == null && textureUrl == null) {
            Apugli.LOG.warn(this.getPowerClassString() + " '" + this.getType().getIdentifier() + "' does not have a valid `texture_location` or `texture_url` field. This power will not render.");
        }
    }

    @Nullable
    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    @Nullable
    public String getTextureUrl() {
        return this.textureUrl;
    }

    public ResourceLocation getUrlTextureIdentifier() {
        return new ResourceLocation("apugli", this.getPowerClassString().toLowerCase(Locale.ROOT) + "/" + this.getType().getIdentifier().m_135827_() + "/" + this.getType().getIdentifier().m_135815_());
    }

    public String getPowerClassString() {
        throw new RuntimeException(String.format("%s does not implement TextureOrUrlPower#getPowerClassString", ((Object)((Object)this)).getClass()));
    }

    public static SerializableData getSerializableData() {
        return new SerializableData().add("texture_location", SerializableDataTypes.IDENTIFIER, null).add("texture_url", SerializableDataTypes.STRING, null);
    }
}

