/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public record ExecuteEntityActionClientPacket<A>(int entityId, A entityAction) implements ApugliPacketS2C
{
    public static final ResourceLocation ID = Apugli.asResource("execute_entity_action_clientside");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        Services.ACTION.entityDataType().send(buf, this.entityAction);
    }

    public static <A> ExecuteEntityActionClientPacket<A> decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        Object entityAction = Services.ACTION.entityDataType().receive(buf);
        return new ExecuteEntityActionClientPacket<Object>(entityId, entityAction);
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                Entity entity = level.m_6815_(ExecuteEntityActionClientPacket.this.entityId);
                if (entity == null) {
                    Apugli.LOG.warn("Could not find entity for clientsided entity action.");
                    return;
                }
                Services.ACTION.executeEntity(ExecuteEntityActionClientPacket.this.entityAction, entity);
            }
        });
    }
}

