/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.mixin.xplatform.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.merchantpug.apugli.client.util.TextureUtilClient;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.EntityTextureOverlayPower;
import net.merchantpug.apugli.power.SetTexturePower;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerEntityRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Unique
    private AbstractClientPlayer apugli$capturedPlayer;

    @Shadow
    public abstract void m_7392_(AbstractClientPlayer var1, float var2, float var3, PoseStack var4, MultiBufferSource var5, int var6);

    public PlayerEntityRendererMixin(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"renderHand"}, at={@At(value="FIELD", target="Lnet/minecraft/client/model/geom/ModelPart;xRot:F", ordinal=0)}, cancellable=true)
    private void apugli$renderOverlayWithCancel(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        List powers = Services.POWER.getPowers((LivingEntity)player, ApugliPowers.ENTITY_TEXTURE_OVERLAY.get());
        if (powers.stream().anyMatch(p -> !p.shouldRenderOriginalModelClient())) {
            arm.f_104203_ = 0.0f;
            sleeve.f_104203_ = 0.0f;
            powers.forEach(power -> this.apugli$renderArmOverlay((EntityTextureOverlayPower)((Object)power), player, matrices, vertexConsumers, light, arm, sleeve));
            ci.cancel();
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="FIELD", target="Lnet/minecraft/client/model/geom/ModelPart;xRot:F", ordinal=1)}, cancellable=true)
    private void apugli$renderOverlayWithCancelSleeve(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        List powers = Services.POWER.getPowers((LivingEntity)player, ApugliPowers.ENTITY_TEXTURE_OVERLAY.get());
        if (powers.stream().allMatch(EntityTextureOverlayPower::shouldRenderOriginalModelClient) && powers.stream().anyMatch(p -> !p.shouldRenderPlayerOuterLayer())) {
            arm.f_104203_ = 0.0f;
            sleeve.f_104203_ = 0.0f;
            powers.forEach(power -> this.apugli$renderArmOverlay((EntityTextureOverlayPower)((Object)power), player, matrices, vertexConsumers, light, arm, sleeve));
            ci.cancel();
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="TAIL")})
    private void apugli$renderOverlayOnArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        List powers = Services.POWER.getPowers((LivingEntity)player, ApugliPowers.ENTITY_TEXTURE_OVERLAY.get());
        if (powers.stream().allMatch(EntityTextureOverlayPower::shouldRenderOriginalModelClient)) {
            return;
        }
        powers.forEach(power -> this.apugli$renderArmOverlay((EntityTextureOverlayPower)((Object)power), player, matrices, vertexConsumers, light, arm, sleeve));
    }

    @Inject(method={"renderHand"}, at={@At(value="HEAD")})
    private void apugli$capturePlayer(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        this.apugli$capturedPlayer = player;
    }

    @ModifyArg(method={"renderHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;entitySolid(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType;"), index=0)
    private ResourceLocation apugli$capturedPlayer(ResourceLocation location) {
        SetTexturePower texturePower;
        if (Services.POWER.hasPower((LivingEntity)this.apugli$capturedPlayer, ApugliPowers.SET_TEXTURE.get()) && (texturePower = (SetTexturePower)((Object)Services.POWER.getPowers((LivingEntity)this.apugli$capturedPlayer, ApugliPowers.SET_TEXTURE.get()).get(0))).getTextureLocation() != null) {
            return texturePower.getTextureLocation();
        }
        return location;
    }

    @ModifyArg(method={"renderHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;entityTranslucent(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType;"), index=0)
    private ResourceLocation apugli$modifyEntityLayerTranslucent(ResourceLocation location) {
        if (Services.POWER.hasPower((LivingEntity)this.apugli$capturedPlayer, ApugliPowers.SET_TEXTURE.get())) {
            SetTexturePower texturePower = (SetTexturePower)((Object)Services.POWER.getPowers((LivingEntity)this.apugli$capturedPlayer, ApugliPowers.SET_TEXTURE.get()).get(0));
            this.apugli$capturedPlayer = null;
            if (texturePower.getTextureLocation() != null) {
                return texturePower.getTextureLocation();
            }
        }
        return location;
    }

    @Inject(method={"getArmPose"}, at={@At(value="HEAD")}, cancellable=true)
    private static void apugli$setArmPoseWhenModifiedItem(AbstractClientPlayer player, InteractionHand hand, CallbackInfoReturnable<HumanoidModel.ArmPose> cir) {
        if (Services.POWER.getPowers((LivingEntity)player, ApugliPowers.MODIFY_EQUIPPED_ITEM_RENDER.get()).stream().anyMatch(power -> power.shouldOverride() && (power.getSlot() == EquipmentSlot.MAINHAND && hand == InteractionHand.MAIN_HAND && power.shouldOverride() && !power.getStack().m_41619_() || power.getSlot() == EquipmentSlot.OFFHAND && hand == InteractionHand.OFF_HAND && power.shouldOverride() && !power.getStack().m_41619_()))) {
            cir.setReturnValue((Object)HumanoidModel.ArmPose.ITEM);
        }
        if (Services.POWER.getPowers((LivingEntity)player, ApugliPowers.MODIFY_EQUIPPED_ITEM_RENDER.get()).stream().anyMatch(power -> power.shouldOverride() && (power.getSlot() == EquipmentSlot.MAINHAND && hand == InteractionHand.MAIN_HAND && power.getStack().m_41619_() || power.getSlot() == EquipmentSlot.OFFHAND && hand == InteractionHand.OFF_HAND && power.getStack().m_41619_()))) {
            cir.setReturnValue((Object)HumanoidModel.ArmPose.EMPTY);
        }
    }

    @Unique
    public void apugli$renderArmOverlay(EntityTextureOverlayPower power, AbstractClientPlayer player, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ModelPart arm, ModelPart sleeve) {
        if (!power.shouldShowFirstPerson()) {
            return;
        }
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        if (power.shouldUseRenderingPowers()) {
            float[] rgba = Services.PLATFORM.getColorPowerRgba((LivingEntity)player);
            red = rgba[0];
            green = rgba[1];
            blue = rgba[2];
            alpha = rgba[3];
        }
        if (TextureUtilClient.getUrls().containsKey(power.getUrlTextureIdentifier())) {
            renderLayer = (double)alpha == 1.0 ? RenderType.m_110458_((ResourceLocation)power.getUrlTextureIdentifier()) : RenderType.m_110473_((ResourceLocation)power.getUrlTextureIdentifier());
            arm.m_104306_(matrices, vertexConsumers.m_6299_(renderLayer), light, OverlayTexture.f_118083_, red, green, blue, alpha);
            sleeve.m_104306_(matrices, vertexConsumers.m_6299_(renderLayer), light, OverlayTexture.f_118083_, red, green, blue, alpha);
        } else if (power.getTextureLocation() != null) {
            renderLayer = (double)alpha == 1.0 ? RenderType.m_110458_((ResourceLocation)power.getTextureLocation()) : RenderType.m_110473_((ResourceLocation)power.getTextureLocation());
            arm.m_104306_(matrices, vertexConsumers.m_6299_(renderLayer), light, OverlayTexture.f_118083_, red, green, blue, alpha);
            sleeve.m_104306_(matrices, vertexConsumers.m_6299_(renderLayer), light, OverlayTexture.f_118083_, red, green, blue, alpha);
        }
    }
}

