/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.condition.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class CachedBlockInRadiusCondition
implements IConditionFactory<Entity> {
    private static final Map<BlockPos, Map<SerializableData.Instance, Boolean>> CHECKED_BLOCK_POS_CACHE = new ConcurrentHashMap<BlockPos, Map<SerializableData.Instance, Boolean>>();
    private static final Map<BlockPos, Map<SerializableData.Instance, Tuple<Collection<BlockPos>, Boolean>>> FINAL_VALUE_CACHE = new ConcurrentHashMap<BlockPos, Map<SerializableData.Instance, Tuple<Collection<BlockPos>, Boolean>>>();
    private static final Map<SerializableData.Instance, Map<Entity, Integer>> ENTITIES = new HashMap<SerializableData.Instance, Map<Entity, Integer>>();

    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("block_condition", Services.CONDITION.blockDataType(), null).add("radius", SerializableDataTypes.INT).add("shape", SerializableDataType.enumValue(Shape.class), (Object)Shape.CUBE).add("compare_to", SerializableDataTypes.INT, (Object)1).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL);
    }

    @Override
    public boolean check(SerializableData.Instance data, Entity entity) {
        int invalidationDistance = data.getInt("radius") * data.getInt("radius") * 2;
        ENTITIES.computeIfAbsent(data, instance -> new ConcurrentHashMap());
        if (!ENTITIES.get(data).containsKey(entity)) {
            ENTITIES.get(data).put(entity, 0);
        }
        for (BlockPos blockPos : CHECKED_BLOCK_POS_CACHE.keySet()) {
            if (!ENTITIES.get(data).keySet().stream().allMatch(e -> e.m_20238_(pos.m_252807_()) >= (double)invalidationDistance)) continue;
            CachedBlockInRadiusCondition.invalidate(blockPos, data);
        }
        for (Map.Entry entry : ENTITIES.get(data).entrySet()) {
            if ((Integer)entry.getValue() > ENTITIES.get(data).size()) {
                ENTITIES.get(data).remove(entry.getKey());
                continue;
            }
            entry.setValue((Integer)entry.getValue() + 1);
            if (entry.getKey() != entity) continue;
            entry.setValue(0);
        }
        return CachedBlockInRadiusCondition.getReturnValue(entity.m_9236_(), entity.m_20183_(), data);
    }

    public static void invalidate(BlockPos pos, SerializableData.Instance data) {
        if (CHECKED_BLOCK_POS_CACHE.containsKey(pos) && CHECKED_BLOCK_POS_CACHE.get(pos) != null) {
            CHECKED_BLOCK_POS_CACHE.get(pos).remove(data);
            if (CHECKED_BLOCK_POS_CACHE.get(pos).isEmpty()) {
                CHECKED_BLOCK_POS_CACHE.remove(pos);
            }
        }
        for (Map.Entry<BlockPos, Map<SerializableData.Instance, Tuple<Collection<BlockPos>, Boolean>>> entry : FINAL_VALUE_CACHE.entrySet()) {
            if (!entry.getValue().containsKey(data) || !((Collection)entry.getValue().get(data).m_14418_()).contains(pos)) continue;
            FINAL_VALUE_CACHE.get(entry.getKey()).remove(data);
            if (!FINAL_VALUE_CACHE.get(entry.getKey()).isEmpty()) break;
            FINAL_VALUE_CACHE.remove(entry.getKey());
            break;
        }
    }

    public static void invalidate(BlockPos pos) {
        CHECKED_BLOCK_POS_CACHE.remove(pos);
        for (Map.Entry<BlockPos, Map<SerializableData.Instance, Tuple<Collection<BlockPos>, Boolean>>> entry : FINAL_VALUE_CACHE.entrySet()) {
            for (SerializableData.Instance data : entry.getValue().keySet()) {
                if (!((Collection)entry.getValue().get(data).m_14418_()).contains(pos)) continue;
                FINAL_VALUE_CACHE.remove(entry.getKey());
            }
        }
    }

    public static void clearCache() {
        CHECKED_BLOCK_POS_CACHE.clear();
        FINAL_VALUE_CACHE.clear();
        ENTITIES.clear();
    }

    public static boolean getReturnValue(Level level, BlockPos center, SerializableData.Instance data) {
        if (FINAL_VALUE_CACHE.containsKey(center) && FINAL_VALUE_CACHE.get(center).containsKey(data)) {
            return (Boolean)FINAL_VALUE_CACHE.get(center).get(data).m_14419_();
        }
        Comparison comparison = (Comparison)data.get("comparison");
        int compareTo = data.getInt("compare_to");
        Shape shape = (Shape)data.get("shape");
        int radius = data.getInt("radius");
        HashSet<BlockPos> collection = new HashSet<BlockPos>();
        int count = 0;
        int stopAt = -1;
        switch (comparison) {
            case EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: {
                stopAt = compareTo + 1;
                break;
            }
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                stopAt = compareTo;
            }
        }
        block4: for (int r = 0; r <= radius; ++r) {
            if (r == 0) {
                if ((count = CachedBlockInRadiusCondition.incrementCountIfPosCheck(count, center, level, data, collection)) != stopAt) continue;
                break;
            }
            for (int j = 0; j < 3; ++j) {
                Vec3i tangent2;
                Vec3i tangent1;
                Vec3i direction;
                Vec3i vec3i = j == 0 ? new Vec3i(0, 1, 0) : (direction = j == 1 ? new Vec3i(1, 0, 0) : new Vec3i(0, 0, 1));
                if (j == 0) {
                    tangent1 = new Vec3i(1, 0, 0);
                    tangent2 = new Vec3i(0, 0, 1);
                } else {
                    tangent1 = direction.m_7724_(new Vec3i(0, 1, 0));
                    tangent2 = new Vec3i(0, 1, 0);
                }
                int offset = j == 0 ? 0 : 1;
                for (int l1 = -r + offset; l1 <= r; ++l1) {
                    for (int l2 = -r + offset; l2 <= r - offset; ++l2) {
                        BlockPos negativeOffsetPos;
                        BlockPos offsetPos;
                        Vec3i p = direction.m_142393_(r);
                        p = p.m_121955_(tangent1.m_142393_(l1));
                        p = p.m_121955_(tangent2.m_142393_(l2));
                        if (!(shape != Shape.CUBE && shape != Shape.CHEBYSHEV && (shape != Shape.SPHERE && shape != Shape.EUCLIDEAN || p.m_123341_() * p.m_123341_() + p.m_123342_() * p.m_123342_() + p.m_123343_() * p.m_123343_() > radius * radius) && Math.abs(p.m_123341_()) + Math.abs(p.m_123342_()) + Math.abs(p.m_123343_()) > radius || (count = CachedBlockInRadiusCondition.incrementCountIfPosCheck(count, offsetPos = center.m_121955_(p), level, data, collection)) != stopAt && (count = CachedBlockInRadiusCondition.incrementCountIfPosCheck(count, negativeOffsetPos = center.m_121955_(p.m_142393_(-1)), level, data, collection)) != stopAt)) break;
                    }
                    if (count == stopAt) break;
                }
                if (count == stopAt) continue block4;
            }
        }
        Map cache = FINAL_VALUE_CACHE.computeIfAbsent(center, pos -> new ConcurrentHashMap());
        int finalCount = count;
        Tuple cacheValue = cache.computeIfAbsent(data, d -> new Tuple((Object)collection, (Object)comparison.compare((double)finalCount, (double)compareTo)));
        return (Boolean)cacheValue.m_14419_();
    }

    private static int incrementCountIfPosCheck(int currentCount, BlockPos pos, Level level, SerializableData.Instance data, Collection<BlockPos> collection) {
        Map cache = CHECKED_BLOCK_POS_CACHE.computeIfAbsent(pos, p -> new ConcurrentHashMap());
        boolean bl = cache.computeIfAbsent(data, d -> Services.CONDITION.checkBlock((SerializableData.Instance)d, "block_condition", level, pos));
        collection.add(pos);
        if (bl) {
            ++currentCount;
        }
        return currentCount;
    }
}

