/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.client;

import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import java.util.HashMap;
import java.util.HashSet;
import net.merchantpug.apugli.access.HumanoidMobRendererAccess;
import net.merchantpug.apugli.capability.entity.KeyPressCapability;
import net.merchantpug.apugli.client.renderer.CustomProjectileRenderer;
import net.merchantpug.apugli.client.renderer.EnergySwirlLayer;
import net.merchantpug.apugli.client.renderer.EntityTextureOverlayLayer;
import net.merchantpug.apugli.client.renderer.PowerCustomHeadLayer;
import net.merchantpug.apugli.client.renderer.PowerHumanoidArmorLayer;
import net.merchantpug.apugli.client.renderer.PowerItemInHandLayer;
import net.merchantpug.apugli.client.util.TextureUtilClient;
import net.merchantpug.apugli.condition.factory.entity.CachedBlockInRadiusCondition;
import net.merchantpug.apugli.mixin.forge.client.accessor.EntityRenderersEventAddLayersAccessor;
import net.merchantpug.apugli.mixin.forge.client.accessor.PlayerModelAccessor;
import net.merchantpug.apugli.mixin.forge.common.accessor.ApoliClientEventHandlerAccessor;
import net.merchantpug.apugli.network.ApugliPacketHandler;
import net.merchantpug.apugli.network.c2s.UpdateKeysPressedPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.PreventLabelRenderPower;
import net.merchantpug.apugli.registry.ApugliEntityTypes;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.merchantpug.apugli.util.FOVUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ApugliForgeClientEventHandler {

    @Mod.EventBusSubscriber(modid="apugli", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModEvents {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(ApugliEntityTypes.CUSTOM_AREA_EFFECT_CLOUD.get(), NoopRenderer::new);
            event.registerEntityRenderer(ApugliEntityTypes.CUSTOM_PROJECTILE.get(), CustomProjectileRenderer::new);
        }

        @SubscribeEvent
        public static void registerRenderLayers(EntityRenderersEvent.AddLayers event) {
            ItemInHandRenderer itemInHandRenderer = Minecraft.m_91087_().m_91290_().m_234586_();
            ((EntityRenderersEventAddLayersAccessor)event).apugli$getRenderers().forEach((entityType, entityRenderer) -> {
                EntityModel patt8386$temp;
                if (!(entityRenderer instanceof LivingEntityRenderer)) {
                    return;
                }
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
                livingEntityRenderer.m_115326_(new EntityTextureOverlayLayer(livingEntityRenderer, false, event.getEntityModels()));
                livingEntityRenderer.m_115326_(new EnergySwirlLayer(livingEntityRenderer));
                if (livingEntityRenderer.m_7200_() instanceof ArmedModel) {
                    livingEntityRenderer.m_115326_(new PowerItemInHandLayer(livingEntityRenderer, itemInHandRenderer));
                }
                if ((patt8386$temp = livingEntityRenderer.m_7200_()) instanceof HumanoidModel) {
                    HumanoidModel humanoidModel = (HumanoidModel)patt8386$temp;
                    livingEntityRenderer.m_115326_(new PowerHumanoidArmorLayer(livingEntityRenderer, humanoidModel, humanoidModel, event.getContext().m_266367_()));
                }
                if (entityRenderer instanceof HumanoidMobRenderer) {
                    HumanoidMobRenderer humanoidMobRenderer = (HumanoidMobRenderer)entityRenderer;
                    humanoidMobRenderer.m_115326_(new PowerCustomHeadLayer(humanoidMobRenderer, event.getEntityModels(), ((HumanoidMobRendererAccess)humanoidMobRenderer).apugli$getHeadSize().x(), ((HumanoidMobRendererAccess)humanoidMobRenderer).apugli$getHeadSize().y(), ((HumanoidMobRendererAccess)humanoidMobRenderer).apugli$getHeadSize().z(), itemInHandRenderer));
                    ((HumanoidMobRendererAccess)humanoidMobRenderer).apugli$setHeadSize(null);
                } else if (livingEntityRenderer.m_7200_() instanceof HeadedModel) {
                    livingEntityRenderer.m_115326_(new PowerCustomHeadLayer(livingEntityRenderer, event.getEntityModels(), itemInHandRenderer));
                }
            });
            event.getSkins().forEach(s -> {
                PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(s);
                playerRenderer.m_115326_(new EnergySwirlLayer(playerRenderer));
                playerRenderer.m_115326_(new EntityTextureOverlayLayer(playerRenderer, ((PlayerModelAccessor)playerRenderer.m_7200_()).apugli$isSlim(), event.getEntityModels()));
                playerRenderer.m_115326_(new PowerItemInHandLayer(playerRenderer, itemInHandRenderer));
                playerRenderer.m_115326_(new PowerCustomHeadLayer(playerRenderer, event.getEntityModels(), itemInHandRenderer));
                playerRenderer.m_115326_(new PowerHumanoidArmorLayer(playerRenderer, (PlayerModel)playerRenderer.m_7200_(), (PlayerModel)playerRenderer.m_7200_(), event.getContext().m_266367_()));
            });
        }
    }

    @Mod.EventBusSubscriber(modid="apugli", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeEvents {
        private static HashMap<String, Boolean> lastKeyBindingStates = new HashMap();

        public static void handleActiveKeys() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            HashSet addedKeys = new HashSet();
            HashSet removedKeys = new HashSet();
            HashMap currentKeyBindingStates = new HashMap();
            player.getCapability(KeyPressCapability.INSTANCE).ifPresent(capability -> {
                if (!capability.getKeysToCheck().isEmpty()) {
                    if (!ApoliClientEventHandlerAccessor.getInitializedKeyBindingMap()) {
                        ApoliClientEventHandlerAccessor.setInitializedKeyBindingMap(true);
                        Minecraft client = Minecraft.m_91087_();
                        for (int i = 0; i < client.f_91066_.f_92059_.length; ++i) {
                            ApoliClientEventHandlerAccessor.apugli$getIdToKeybindingMap().put(client.f_91066_.f_92059_[i].m_90860_(), client.f_91066_.f_92059_[i]);
                        }
                    }
                    capability.getKeysToCheck().forEach(key -> {
                        KeyMapping keyBinding = ApoliClientEventHandlerAccessor.apugli$getIdToKeybindingMap().get(key.key());
                        if (keyBinding != null) {
                            if (!currentKeyBindingStates.containsKey(key.key())) {
                                currentKeyBindingStates.put(key.key(), keyBinding.m_90857_());
                            }
                            if (currentKeyBindingStates.getOrDefault(key.key(), false).booleanValue() && (key.continuous() || !lastKeyBindingStates.getOrDefault(key.key(), false).booleanValue())) {
                                capability.addKey((IActivePower.Key)key);
                                if (!lastKeyBindingStates.getOrDefault(key.key(), false).booleanValue()) {
                                    addedKeys.add(key);
                                }
                            } else if (!currentKeyBindingStates.getOrDefault(key.key(), false).booleanValue() && lastKeyBindingStates.getOrDefault(key.key(), false).booleanValue()) {
                                capability.removeKey((IActivePower.Key)key);
                                removedKeys.add(key);
                            }
                        }
                    });
                    ApugliPacketHandler.sendC2S(new UpdateKeysPressedPacket(addedKeys, removedKeys));
                }
                lastKeyBindingStates = currentKeyBindingStates;
            });
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void updateFov(ViewportEvent.ComputeFov event) {
            Entity entity;
            Camera activeRenderInfo = event.getCamera();
            double partialTicks = event.getPartialTick();
            boolean useFOVSetting = event.usedConfiguredFov();
            if (useFOVSetting && (entity = activeRenderInfo.m_90592_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                double fov = FOVUtil.undoModifications(event.getFOV(), activeRenderInfo, partialTicks);
                event.setFOV(ApugliPowers.MODIFY_FOV.get().getFov(fov, activeRenderInfo, living));
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            ForgeEvents.handleActiveKeys();
        }

        @SubscribeEvent
        public static void preventNameTagRender(RenderNameTagEvent event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player otherPlayer = (Player)entity;
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (Services.POWER.getPowers((LivingEntity)otherPlayer, ApugliPowers.PREVENT_LABEL_RENDER.get()).stream().anyMatch(arg_0 -> ForgeEvents.lambda$preventNameTagRender$2((Player)localPlayer, arg_0))) {
                event.setResult(Event.Result.DENY);
            }
        }

        @SubscribeEvent
        public static void onLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
            CachedBlockInRadiusCondition.clearCache();
            if (event.getConnection() == null) {
                return;
            }
            TextureUtilClient.clear();
        }

        private static /* synthetic */ boolean lambda$preventNameTagRender$2(Player localPlayer, PreventLabelRenderPower power) {
            return power.shouldHide((LivingEntity)localPlayer);
        }
    }
}

