/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.ResourceOperation;
import io.github.apace100.calio.data.SerializableData;
import java.util.OptionalInt;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ResourceTransferAction
implements IActionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("resource", Services.POWER.getPowerTypeDataType()).add("provider", Services.POWER.getPowerTypeDataType()).add("operation", ApoliDataTypes.RESOURCE_OPERATION, (Object)ResourceOperation.ADD);
    }

    @Override
    public void execute(SerializableData.Instance data, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        OptionalInt resource = Services.POWER.getResource(living, data, "resource");
        if (resource.isEmpty()) {
            return;
        }
        OptionalInt provider = Services.POWER.getResource(living, data, "provider");
        if (provider.isEmpty()) {
            return;
        }
        Services.POWER.setResource(living, data, "resource", switch ((ResourceOperation)data.get("operation")) {
            case ResourceOperation.ADD -> resource.getAsInt() + provider.getAsInt();
            case ResourceOperation.SET -> provider.getAsInt();
            default -> throw new IllegalArgumentException("Unexpected Resource Operation, should only be ADD or SET!");
        });
    }
}

