/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.bientity;

import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Vector3f;

public class AddVelocityAction
implements IActionFactory<Tuple<Entity, Entity>> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("x", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("y", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("z", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("horizontal_modifier", Services.PLATFORM.getModifierDataType(), null).add("horizontal_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("vertical_modifier", Services.PLATFORM.getModifierDataType(), null).add("vertical_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("horizontal_post_modifier", Services.PLATFORM.getModifierDataType(), null).add("horizontal_post_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("vertical_post_modifier", Services.PLATFORM.getModifierDataType(), null).add("vertical_post_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("client", SerializableDataTypes.BOOLEAN, (Object)true).add("server", SerializableDataTypes.BOOLEAN, (Object)true).add("set", SerializableDataTypes.BOOLEAN, (Object)false).add("reference", SerializableDataType.enumValue(Reference.class), (Object)Reference.POSITION);
    }

    @Override
    public void execute(SerializableData.Instance data, Tuple<Entity, Entity> pair) {
        Entity actor = (Entity)pair.m_14418_();
        Entity target = (Entity)pair.m_14419_();
        if (actor == null || target == null || target instanceof Player && (target.m_9236_().m_5776_() ? !data.getBoolean("client") : !data.getBoolean("server"))) {
            return;
        }
        Vector3f vec = new Vector3f(data.getFloat("x"), data.getFloat("y"), data.getFloat("z"));
        vec.set(this.applyModifiers(data, actor, vec.x(), "horizontal_modifier"), this.applyModifiers(data, actor, vec.y(), "vertical_modifier"), this.applyModifiers(data, actor, vec.z(), "horizontal_modifier"));
        TriConsumer method = data.getBoolean("set") ? (arg_0, arg_1, arg_2) -> ((Entity)target).m_20334_(arg_0, arg_1, arg_2) : (x, y, z) -> target.m_20256_(target.m_20184_().m_82520_((double)x.floatValue(), (double)y.floatValue(), (double)z.floatValue()));
        Reference reference = (Reference)((Object)data.get("reference"));
        Vec3 refVec = reference.apply(actor, target);
        Space.transformVectorToBase((Vec3)refVec, (Vector3f)vec, (float)actor.m_146908_(), (boolean)true);
        method.accept((Object)Float.valueOf(this.applyModifiers(data, actor, vec.x(), "horizontal_post_modifier")), (Object)Float.valueOf(this.applyModifiers(data, actor, vec.y(), "vertical_post_modifier")), (Object)Float.valueOf(this.applyModifiers(data, actor, vec.z(), "horizontal_post_modifier")));
        target.f_19864_ = true;
    }

    private float applyModifiers(SerializableData.Instance data, Entity entity, float original, String modifierKey) {
        if (!data.isPresent(modifierKey) && !data.isPresent(modifierKey + "s")) {
            return original;
        }
        return (float)Services.PLATFORM.applyModifiers(entity, this.getModifiers(data, modifierKey), (double)original);
    }

    private <M> List<M> getModifiers(SerializableData.Instance data, String modifierKey) {
        return this.getModifiers(data, modifierKey, modifierKey + "s");
    }

    private <M> List<M> getModifiers(SerializableData.Instance data, String modifierKey, String modifiersKey) {
        ArrayList modifiers = new ArrayList();
        data.ifPresent(modifiersKey, modifiers::addAll);
        data.ifPresent(modifierKey, modifiers::add);
        return modifiers;
    }

    public static enum Reference {
        POSITION((actor, target) -> target.m_20182_().m_82546_(actor.m_20182_())),
        ROTATION((actor, target) -> {
            float pitch = actor.m_146909_();
            float yaw = actor.m_146908_();
            float i = (float)Math.PI / 180;
            float j = -Mth.m_14031_((float)(yaw * i)) * Mth.m_14089_((float)(pitch * i));
            float k = -Mth.m_14031_((float)(pitch * i));
            float l = Mth.m_14089_((float)(yaw * i)) * Mth.m_14089_((float)(pitch * i));
            return new Vec3((double)j, (double)k, (double)l);
        });

        final BiFunction<Entity, Entity, Vec3> refFunction;

        private Reference(BiFunction<Entity, Entity, Vec3> refFunction) {
            this.refFunction = refFunction;
        }

        public Vec3 apply(Entity actor, Entity target) {
            return this.refFunction.apply(actor, target);
        }
    }
}

