/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.mixin;

import com.leclowndu93150.corpsecurioscompat.Config;
import com.leclowndu93150.corpsecurioscompat.data.CuriosSlotDataComponent;
import com.leclowndu93150.corpsecurioscompat.util.CuriosSlotDetector;
import com.leclowndu93150.corpsecurioscompat.util.DelayedCurioHandler;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseAdditionalContainer;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mixin(value={CorpseInventoryContainer.class, CorpseAdditionalContainer.class})
public abstract class CorpseContainerMixin {
    private Player cachedPlayer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history, CallbackInfo ci) {
        if (playerInventory != null) {
            this.cachedPlayer = playerInventory.f_35978_;
        }
    }

    @Inject(method={"transferItems"}, at={@At(value="HEAD")}, remap=false)
    private void transferItemsToCurios(CallbackInfo ci) {
        ItemStack stack;
        int i;
        CorpseContainerMixin container = this;
        if (this.cachedPlayer == null || !this.cachedPlayer.m_6084_()) {
            return;
        }
        if (!((CorpseContainerBase)container).isEditable()) {
            return;
        }
        Optional curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.cachedPlayer).resolve();
        if (curiosOpt.isEmpty()) {
            return;
        }
        ICuriosItemHandler curiosHandler = (ICuriosItemHandler)curiosOpt.get();
        Map curios = curiosHandler.getCurios();
        ArrayList<ItemStack> curioItems = new ArrayList<ItemStack>();
        ArrayList<Consumer<ItemStack>> clearActions = new ArrayList<Consumer<ItemStack>>();
        if (container instanceof CorpseInventoryContainer) {
            CorpseInventoryContainer corpseContainer = (CorpseInventoryContainer)container;
            for (i = 0; i < corpseContainer.f_38839_.size() && i < corpseContainer.getInventorySize(); ++i) {
                ItemStack stack2;
                slot = corpseContainer.m_38853_(i);
                if (slot == null || (stack2 = slot.m_7993_()).m_41619_() || !this.corpse_Curios_Compat$shouldTransferCurio(stack2)) continue;
                curioItems.add(stack2.m_41777_());
                slotIndex = i;
                clearActions.add(s -> corpseContainer.m_38853_(slotIndex).m_5852_(ItemStack.f_41583_));
            }
            for (i = 0; i < corpseContainer.getCorpse().getDeath().getAdditionalItems().size(); ++i) {
                ItemStack stack3 = (ItemStack)corpseContainer.getCorpse().getDeath().getAdditionalItems().get(i);
                if (stack3.m_41619_() || !this.corpse_Curios_Compat$shouldTransferCurio(stack3)) continue;
                curioItems.add(stack3.m_41777_());
                int index = i;
                clearActions.add(s -> corpseContainer.getCorpse().getDeath().getAdditionalItems().set(index, (Object)ItemStack.f_41583_));
            }
        } else if (container instanceof CorpseAdditionalContainer) {
            CorpseAdditionalContainer additionalContainer = (CorpseAdditionalContainer)container;
            for (i = 0; i < additionalContainer.getInventorySize(); ++i) {
                ItemStack stack4;
                slot = additionalContainer.m_38853_(i);
                if (slot == null || (stack4 = slot.m_7993_()).m_41619_() || !this.corpse_Curios_Compat$shouldTransferCurio(stack4)) continue;
                curioItems.add(stack4.m_41777_());
                slotIndex = i;
                clearActions.add(s -> additionalContainer.m_38853_(slotIndex).m_5852_(ItemStack.f_41583_));
            }
        }
        ArrayList<ItemStack> priorityItems = new ArrayList<ItemStack>();
        ArrayList<Consumer> priorityClearActions = new ArrayList<Consumer>();
        ArrayList<ItemStack> regularItems = new ArrayList<ItemStack>();
        ArrayList<Consumer> regularClearActions = new ArrayList<Consumer>();
        for (i = 0; i < curioItems.size(); ++i) {
            stack = (ItemStack)curioItems.get(i);
            CuriosSlotDataComponent.CurioSlotData slotData = CuriosSlotDataComponent.getCurioSlotData(stack);
            if (slotData != null && CuriosSlotDetector.doesItemAddSlots(stack, this.cachedPlayer, slotData.slotType())) {
                priorityItems.add(stack);
                priorityClearActions.add((Consumer)clearActions.get(i));
                continue;
            }
            regularItems.add(stack);
            regularClearActions.add((Consumer)clearActions.get(i));
        }
        for (i = 0; i < priorityItems.size(); ++i) {
            stack = (ItemStack)priorityItems.get(i);
            if (!this.corpse_Curios_Compat$tryTransferPreviouslyEquippedCurio(stack, curios)) continue;
            ((Consumer)priorityClearActions.get(i)).accept(stack);
        }
        if (!regularItems.isEmpty() && !priorityItems.isEmpty()) {
            for (i = 0; i < regularItems.size(); ++i) {
                ItemStack itemCopy = ((ItemStack)regularItems.get(i)).m_41777_();
                ((Consumer)regularClearActions.get(i)).accept((ItemStack)regularItems.get(i));
                regularItems.set(i, itemCopy);
            }
            DelayedCurioHandler.scheduleCurioRestoration(this.cachedPlayer, regularItems);
        } else {
            for (i = 0; i < regularItems.size(); ++i) {
                stack = (ItemStack)regularItems.get(i);
                if (!this.corpse_Curios_Compat$tryTransferPreviouslyEquippedCurio(stack, curios)) continue;
                ((Consumer)regularClearActions.get(i)).accept(stack);
            }
        }
    }

    @Unique
    private boolean corpse_Curios_Compat$shouldTransferCurio(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty()) {
            return false;
        }
        CuriosSlotDataComponent.CurioSlotData slotData = CuriosSlotDataComponent.getCurioSlotData(stack);
        if (slotData == null || !slotData.wasEquipped()) {
            return false;
        }
        if (Config.isItemBlacklisted(stack.m_41720_())) {
            return false;
        }
        return Config.shouldTransferCursedItems() || !Config.isItemCursed(stack);
    }

    @Unique
    private boolean corpse_Curios_Compat$tryTransferPreviouslyEquippedCurio(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        if (stack.m_41619_()) {
            return false;
        }
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty()) {
            return false;
        }
        CuriosSlotDataComponent.CurioSlotData slotData = CuriosSlotDataComponent.getCurioSlotData(stack);
        if (slotData == null || !slotData.wasEquipped()) {
            return false;
        }
        if (Config.isItemBlacklisted(stack.m_41720_())) {
            return false;
        }
        if (!Config.shouldTransferCursedItems() && Config.isItemCursed(stack)) {
            return false;
        }
        String slotType = slotData.slotType();
        int slotIndex = slotData.slotIndex();
        ICurioStacksHandler handler = curios.get(slotType);
        if (handler != null && slotIndex >= 0) {
            try {
                IDynamicStackHandler targetStacks = slotData.isCosmetic() ? handler.getCosmeticStacks() : handler.getStacks();
                int availableSlots = targetStacks.getSlots();
                if (slotIndex < availableSlots) {
                    ItemStack existingStack = targetStacks.getStackInSlot(slotIndex);
                    if (!existingStack.m_41619_()) {
                        ItemStack cleanStack = stack.m_41777_();
                        CuriosSlotDataComponent.removeCurioSlotData(cleanStack);
                        if (!this.cachedPlayer.m_150109_().m_36054_(cleanStack)) {
                            this.cachedPlayer.m_36176_(cleanStack, false);
                        }
                        return true;
                    }
                    ItemStack cleanStack = stack.m_41777_();
                    CuriosSlotDataComponent.removeCurioSlotData(cleanStack);
                    targetStacks.setStackInSlot(slotIndex, cleanStack);
                    return true;
                }
            }
            catch (IndexOutOfBoundsException e) {
                ItemStack cleanStack = stack.m_41777_();
                CuriosSlotDataComponent.removeCurioSlotData(cleanStack);
                if (!this.cachedPlayer.m_150109_().m_36054_(cleanStack)) {
                    this.cachedPlayer.m_36176_(cleanStack, false);
                }
                return true;
            }
        }
        ItemStack cleanStack = stack.m_41777_();
        CuriosSlotDataComponent.removeCurioSlotData(cleanStack);
        if (!this.cachedPlayer.m_150109_().m_36054_(cleanStack)) {
            this.cachedPlayer.m_36176_(cleanStack, false);
        }
        return true;
    }
}

