/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnLevelsLoaded;
import com.majruszlibrary.events.OnServerTicked;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.data.WorldData;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import org.jetbrains.annotations.Nullable;

public class UndeadArmyHelper {
    private static List<UndeadArmy> UNDEAD_ARMIES = new ArrayList<UndeadArmy>();

    public static boolean tryToSpawn(Player player) {
        return EntityHelper.isOutside((Entity)player) && EntityHelper.isIn((Entity)player, (ResourceKey)Level.f_46428_) && UndeadArmyHelper.tryToSpawn(UndeadArmyHelper.getAttackPosition(player), Optional.empty());
    }

    public static boolean tryToSpawn(BlockPos position, Optional<UndeadArmy.Direction> direction) {
        return UndeadArmyConfig.IS_ENABLED && UndeadArmyHelper.getLevel().m_46791_() != Difficulty.PEACEFUL && !UndeadArmyHelper.getLevel().m_46469_().m_46207_(GameRules.f_46154_) && UndeadArmyHelper.findNearestUndeadArmy(position) == null && UndeadArmyHelper.setupNewArmy(position, direction);
    }

    @Nullable
    public static UndeadArmy findNearestUndeadArmy(BlockPos position) {
        UndeadArmy nearestArmy = null;
        double minDistance = Double.MAX_VALUE;
        for (UndeadArmy undeadArmy : UNDEAD_ARMIES) {
            double distance;
            if (!undeadArmy.isInRange(position) || !((distance = undeadArmy.distanceTo(position)) < minDistance)) continue;
            nearestArmy = undeadArmy;
            minDistance = distance;
        }
        return nearestArmy;
    }

    public static boolean isPartOfUndeadArmy(Entity entity) {
        return UNDEAD_ARMIES.stream().anyMatch(undeadArmy -> undeadArmy.isPartOfWave(entity));
    }

    public static List<UndeadArmy> getUndeadArmies() {
        return Collections.unmodifiableList(UNDEAD_ARMIES);
    }

    public static ServerLevel getLevel() {
        return Side.getServer().m_129783_();
    }

    private static void setupDefaultValues(OnLevelsLoaded data) {
        UNDEAD_ARMIES = new ArrayList<UndeadArmy>();
    }

    private static void tick(OnServerTicked data) {
        UNDEAD_ARMIES.forEach(UndeadArmy::tick);
        boolean hasAnyArmyFinished = UNDEAD_ARMIES.removeIf(UndeadArmy::hasFinished);
        if (hasAnyArmyFinished && UNDEAD_ARMIES.isEmpty()) {
            LevelHelper.setClearWeather((Level)UndeadArmyHelper.getLevel(), (int)TimeHelper.toTicks((double)0.5));
            LevelData levelData = UndeadArmyHelper.getLevel().m_6106_();
            if (levelData instanceof ServerLevelData) {
                ServerLevelData levelData2 = (ServerLevelData)levelData;
                levelData2.m_6393_(TimeHelper.toTicks((double)1800.0));
            }
        }
    }

    private static boolean setupNewArmy(BlockPos position, Optional<UndeadArmy.Direction> direction) {
        UndeadArmy undeadArmy = new UndeadArmy();
        undeadArmy.start(position, direction.orElse((UndeadArmy.Direction)((Object)Random.next((Object[])UndeadArmy.Direction.values()))));
        UNDEAD_ARMIES.add(undeadArmy);
        return true;
    }

    private static BlockPos getAttackPosition(Player player) {
        int x = (int)player.m_20185_();
        int z = (int)player.m_20189_();
        return new BlockPos(x, player.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, x, z), z);
    }

    static {
        OnLevelsLoaded.listen(UndeadArmyHelper::setupDefaultValues);
        OnServerTicked.listen(UndeadArmyHelper::tick);
        Serializables.getStatic(WorldData.class).define("undead_armies", Reader.list((IReader)Reader.custom(UndeadArmy::new)), () -> UNDEAD_ARMIES, v -> {
            UNDEAD_ARMIES = v;
        });
    }
}

