/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnItemInventoryClicked;
import com.majruszlibrary.events.OnPlayerInteracted;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.treasurebag.events.OnTreasureBagOpened;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TreasureBag
extends Item {
    private final ResourceLocation lootId;

    public static Supplier<TreasureBag> angler() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_angler"));
    }

    public static Supplier<TreasureBag> elderGuardian() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_elder_guardian"));
    }

    public static Supplier<TreasureBag> enderDragon() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_ender_dragon"));
    }

    public static Supplier<TreasureBag> pillager() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_pillager"));
    }

    public static Supplier<TreasureBag> undeadArmy() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_undead_army"));
    }

    public static Supplier<TreasureBag> warden() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_warden"));
    }

    public static Supplier<TreasureBag> wither() {
        return () -> new TreasureBag(MajruszsDifficulty.HELPER.getLocation("gameplay/treasure_bag_wither"));
    }

    public TreasureBag(ResourceLocation lootId) {
        super(new Item.Properties().m_41487_(16).m_41497_(Rarity.UNCOMMON));
        this.lootId = lootId;
    }

    public ResourceLocation getLootId() {
        return this.lootId;
    }

    private static void openInHand(OnPlayerInteracted data) {
        if (Side.isLogicalServer()) {
            TreasureBag.open(data.itemStack, data.player);
        }
        data.finish();
    }

    private static void openInInventory(RightClickAction action, ServerPlayer player) {
        TimeHelper.nextTick(d -> {
            if (!player.f_36096_.m_207775_(action.containerIdx)) {
                return;
            }
            ItemStack itemStack = player.f_36096_.m_38853_(action.containerIdx).m_7993_();
            if (itemStack.m_41720_() instanceof TreasureBag) {
                TreasureBag.open(itemStack, (Player)player);
            }
        });
    }

    private static void open(ItemStack itemStack, Player player) {
        TreasureBag treasureBag = (TreasureBag)itemStack.m_41720_();
        ObjectArrayList loot = LootHelper.getLootTable((ResourceLocation)treasureBag.lootId).m_287195_(LootHelper.toGiftParams((Entity)player));
        SoundEmitter.of((SoundEvent)SoundEvents.f_12019_).position(player.m_20182_()).emit(player.m_9236_());
        Events.dispatch((Object)new OnTreasureBagOpened(player, treasureBag, (List<ItemStack>)loot));
        loot.forEach(reward -> ItemHelper.giveToPlayer((ItemStack)reward, (Player)player));
        ItemHelper.consumeItemOnUse((ItemStack)itemStack, (Player)player);
    }

    static {
        OnPlayerInteracted.listen(TreasureBag::openInHand).addCondition(data -> data.itemStack.m_41720_() instanceof TreasureBag);
        Serializables.get(RightClickAction.class).define("container_idx", Reader.integer(), s -> s.containerIdx, (s, v) -> {
            s.containerIdx = v;
        });
        MajruszsDifficulty.TREASURE_BAG_RIGHT_CLICK_NETWORK.addServerCallback(TreasureBag::openInInventory);
    }

    public static class RightClickAction {
        public int containerIdx;

        public RightClickAction(int containerIdx) {
            this.containerIdx = containerIdx;
        }

        public RightClickAction() {
            this(-1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        private static void openInInventory(OnItemInventoryClicked data) {
            MajruszsDifficulty.TREASURE_BAG_RIGHT_CLICK_NETWORK.sendToServer((Object)new RightClickAction(data.containerIdx));
            data.cancel();
        }

        static {
            OnItemInventoryClicked.listen(Client::openInInventory).addCondition(data -> data.itemStack.m_41720_() instanceof TreasureBag).addCondition(data -> data.action == 1);
        }
    }
}

