/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnBreakSpeedGet;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnEntitySwimSpeedMultiplierGet;
import com.majruszlibrary.events.OnItemAttributeTooltip;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.OnItemRenderColorsGet;
import com.majruszlibrary.events.OnItemTooltip;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.OnPlayerInteracted;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.events.OnSoulJarMultiplierGet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulJar
extends Item {
    private static final float DAMAGE_BONUS = 3.0f;
    private static final float MOVE_BONUS = 0.15f;
    private static final int ARMOR_BONUS = 3;
    private static final float MINE_BONUS = 0.15f;
    private static final int LUCK_BONUS = 1;
    private static final float SWIM_BONUS = 0.3f;
    private static final AttributeHandler ARMOR_ATTRIBUTE = new AttributeHandler("soul_jar_armor_bonus", () -> Attributes.f_22284_, AttributeModifier.Operation.ADDITION);
    private static final AttributeHandler LUCK_ATTRIBUTE = new AttributeHandler("soul_jar_luck_bonus", () -> Attributes.f_22286_, AttributeModifier.Operation.ADDITION);
    private static final AttributeHandler MOVE_ATTRIBUTE = new AttributeHandler("soul_jar_movement_bonus", () -> Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public SoulJar() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    private static void randomize(OnPlayerInteracted data) {
        SoulJar.tryToRandomize(data.itemStack);
    }

    private static void increaseDamage(OnEntityPreDamaged data) {
        data.damage += 3.0f * SoulJar.getMultiplier(data.attacker, data.attacker.m_21206_());
        data.spawnMagicParticles = true;
    }

    private static void increaseMineSpeed(OnBreakSpeedGet data) {
        data.speed += data.original * 0.15f * SoulJar.getMultiplier((LivingEntity)data.player, data.player.m_21206_());
    }

    private static void increaseSwimSpeed(OnEntitySwimSpeedMultiplierGet data) {
        data.multiplier += data.original * 0.3f * SoulJar.getMultiplier(data.entity, data.entity.m_21206_());
    }

    private static void updateAttributes(OnItemEquipped data) {
        ItemStack itemStack = data.entity.m_21206_();
        float multiplier = SoulJar.canHaveSouls(itemStack) ? SoulJar.getMultiplier(data.entity, itemStack) : 0.0f;
        BonusInfo bonusInfo = BonusInfo.read(itemStack);
        ARMOR_ATTRIBUTE.setValue((double)((bonusInfo.has(BonusType.ARMOR) ? 3.0f : 0.0f) * multiplier)).apply(data.entity);
        LUCK_ATTRIBUTE.setValue((double)((bonusInfo.has(BonusType.LUCK) ? 1.0f : 0.0f) * multiplier)).apply(data.entity);
        MOVE_ATTRIBUTE.setValue((double)((bonusInfo.has(BonusType.MOVE) ? 0.15f : 0.0f) * multiplier)).apply(data.entity);
    }

    private static void randomize(OnLootGenerated data) {
        data.generatedLoot.forEach(SoulJar::tryToRandomize);
    }

    private static void decreaseShieldBonus(OnSoulJarMultiplierGet data) {
        data.multiplier *= 0.6666667f;
    }

    private static void tryToRandomize(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof SoulJar) {
            Serializables.modify((Object)new BonusInfo(), (Tag)itemStack.m_41784_(), bonusInfo -> {
                if (bonusInfo.getBonusTypes().isEmpty()) {
                    bonusInfo.randomize();
                }
            });
        }
    }

    private static float getMultiplier(LivingEntity entity, ItemStack itemStack) {
        return ((OnSoulJarMultiplierGet)Events.dispatch((Object)new OnSoulJarMultiplierGet(entity, itemStack))).getMultiplier();
    }

    private static boolean canHaveSouls(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof SoulJar || itemStack.m_41720_() instanceof ShieldItem;
    }

    static {
        OnPlayerInteracted.listen(SoulJar::randomize).addCondition(data -> SoulJar.canHaveSouls(data.itemStack));
        OnLootGenerated.listen(SoulJar::randomize);
        OnEntityPreDamaged.listen(SoulJar::increaseDamage).addCondition(data -> {
            Mob mob;
            LivingEntity patt2464$temp = data.target;
            return patt2464$temp instanceof Mob && (mob = (Mob)patt2464$temp).m_6336_() == MobType.f_21641_;
        }).addCondition(data -> data.attacker != null).addCondition(data -> BonusInfo.has(data.attacker, BonusType.DAMAGE));
        OnBreakSpeedGet.listen(SoulJar::increaseMineSpeed).addCondition(data -> BonusInfo.has((LivingEntity)data.player, BonusType.MINE));
        OnEntitySwimSpeedMultiplierGet.listen(SoulJar::increaseSwimSpeed).addCondition(data -> BonusInfo.has(data.entity, BonusType.SWIM));
        OnItemEquipped.listen(SoulJar::updateAttributes);
        OnSoulJarMultiplierGet.listen(SoulJar::decreaseShieldBonus).addCondition(data -> data.itemStack.m_41720_() instanceof ShieldItem);
        Serializables.get(BonusInfo.class).define("SoulJarBonusMask", Reader.integer(), BonusInfo::getMask, BonusInfo::setMask);
    }

    public static class BonusInfo {
        private static final int BONUS_COUNT = 3;
        public final List<BonusType> bonuses = new ArrayList<BonusType>();

        public static BonusInfo read(ItemStack itemStack) {
            BonusInfo bonusInfo = new BonusInfo();
            CompoundTag tag = itemStack.m_41783_();
            return tag != null ? (BonusInfo)Serializables.read((Object)bonusInfo, (Tag)tag) : bonusInfo;
        }

        public static boolean has(LivingEntity entity, BonusType bonusType) {
            return BonusInfo.read(entity.m_21206_()).has(bonusType);
        }

        public void randomize() {
            this.setMask(BonusInfo.toMask(Random.next(Arrays.stream(BonusType.values()).toList(), (int)3)));
        }

        public void setMask(int mask) {
            this.bonuses.clear();
            Arrays.stream(BonusType.values()).filter(bonusType -> (bonusType.getBit() & mask) != 0).forEach(this.bonuses::add);
        }

        public int getMask() {
            return BonusInfo.toMask(this.bonuses);
        }

        public boolean has(BonusType bonusType) {
            return this.bonuses.contains((Object)bonusType);
        }

        public boolean hasBonuses() {
            return !this.bonuses.isEmpty();
        }

        public Optional<BonusType> getBonus(int idx) {
            return idx < this.bonuses.size() ? Optional.of(this.bonuses.get(idx)) : Optional.empty();
        }

        public List<BonusType> getBonusTypes() {
            return this.bonuses;
        }

        public List<Component> getComponents() {
            ArrayList<Component> components = new ArrayList<Component>();
            if (this.bonuses.isEmpty()) {
                MutableComponent bonusCount = TextHelper.literal((String)"%d", (Object[])new Object[]{3}).m_130940_(ChatFormatting.GREEN);
                components.add((Component)TextHelper.translatable((String)"item.majruszsdifficulty.soul_jar.item_tooltip1", (Object[])new Object[]{bonusCount}).m_130940_(ChatFormatting.GRAY));
                components.add((Component)TextHelper.translatable((String)"item.majruszsdifficulty.soul_jar.item_tooltip2", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
            } else {
                components.add((Component)TextHelper.empty());
                components.add((Component)TextHelper.translatable((String)"item.majruszsdifficulty.soul_jar.item_tooltip3", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
                MutableComponent souls = TextHelper.literal((String)"");
                for (BonusType bonusType : this.getBonusTypes()) {
                    souls.m_7220_((Component)bonusType.getSoulComponent().m_130946_(" "));
                }
                components.add((Component)souls);
            }
            return components;
        }

        private static int toMask(List<BonusType> bonuses) {
            int mask = 0;
            for (BonusType bonusType : bonuses) {
                mask |= bonusType.getBit();
            }
            return mask;
        }
    }

    public static enum BonusType {
        DAMAGE("smite", "entity.minecraft.wolf", ChatFormatting.RED, 0xCC5555, multiplier -> TextHelper.signed((float)(3.0f * multiplier.floatValue()))),
        MOVE("move", "entity.minecraft.horse", ChatFormatting.WHITE, 0xDDDDDD, multiplier -> TextHelper.signedPercent((float)(0.15f * multiplier.floatValue()))),
        ARMOR("armor", "entity.majruszsdifficulty.tank", ChatFormatting.BLUE, 0x5555CC, multiplier -> TextHelper.signed((int)((int)(3.0f * multiplier.floatValue())))),
        MINE("mine", "entity.minecraft.sniffer", ChatFormatting.YELLOW, 0xCCCC55, multiplier -> TextHelper.signedPercent((float)(0.15f * multiplier.floatValue()))),
        LUCK("luck", "entity.minecraft.rabbit", ChatFormatting.GREEN, 0x55CC55, multiplier -> TextHelper.signed((float)(1.0f * multiplier.floatValue()))),
        SWIM("swim", "entity.minecraft.dolphin", ChatFormatting.AQUA, 0x55CCCC, multiplier -> TextHelper.signedPercent((float)(0.3f * multiplier.floatValue())));

        final String bonusId;
        final String mobId;
        final ChatFormatting soulFormatting;
        final int color;
        final Function<Float, String> valueProvider;

        private BonusType(String bonusId, String mobId, ChatFormatting soulFormatting, int color, Function<Float, String> valueProvider) {
            this.bonusId = "item.majruszsdifficulty.soul_jar.%s".formatted(bonusId);
            this.mobId = mobId;
            this.soulFormatting = soulFormatting;
            this.color = color;
            this.valueProvider = valueProvider;
        }

        public int getBit() {
            return 1 << this.ordinal();
        }

        public int getColor() {
            return this.color;
        }

        public MutableComponent getBonusComponent(float multiplier) {
            return TextHelper.translatable((String)this.bonusId, (Object[])new Object[]{this.valueProvider.apply(Float.valueOf(multiplier))}).m_130940_(ChatFormatting.BLUE);
        }

        public MutableComponent getSoulComponent() {
            return TextHelper.translatable((String)this.mobId, (Object[])new Object[0]).m_130940_(this.soulFormatting);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        private static void changeSoulColor(OnItemRenderColorsGet data) {
            BonusInfo bonusInfo = BonusInfo.read(data.itemStack);
            for (int idx = 0; idx < 3; ++idx) {
                data.add(idx + 1, bonusInfo.getBonus(idx).map(BonusType::getColor).orElse(0xEEEEEE - idx * 0x111111).intValue());
            }
        }

        private static void addTooltip(OnItemAttributeTooltip data) {
            float multiplier = SoulJar.getMultiplier((LivingEntity)Side.getLocalPlayer(), data.itemStack);
            BonusInfo bonusInfo = BonusInfo.read(data.itemStack);
            for (BonusType bonusType : bonusInfo.getBonusTypes()) {
                data.add(EquipmentSlot.OFFHAND, (Component)bonusType.getBonusComponent(multiplier));
            }
        }

        private static void addTooltip(OnItemTooltip data) {
            BonusInfo bonusInfo = BonusInfo.read(data.itemStack);
            if (bonusInfo.hasBonuses() || data.itemStack.m_41720_() instanceof SoulJar) {
                data.components.addAll(bonusInfo.getComponents());
            }
        }

        static {
            OnItemRenderColorsGet.listen(Client::changeSoulColor).addCondition(data -> data.itemStack.m_41720_() instanceof SoulJar);
            OnItemAttributeTooltip.listen(Client::addTooltip).addCondition(data -> SoulJar.canHaveSouls(data.itemStack)).addCondition(data -> Side.getLocalPlayer() != null);
            OnItemTooltip.listen(Client::addTooltip).addCondition(data -> SoulJar.canHaveSouls(data.itemStack));
        }
    }
}

