/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamestage.listeners;

import com.majruszlibrary.events.OnPlayerLoggedIn;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.platform.Side;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.gamestage.contexts.OnGlobalGameStageChanged;
import com.majruszsdifficulty.gamestage.contexts.OnPlayerGameStageChanged;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AdvancementProvider {
    private static void giveAdvancement(OnGlobalGameStageChanged data) {
        Side.getServer().m_6846_().m_11314_().forEach(player -> MajruszsDifficulty.GAME_STAGE_ADVANCEMENT.trigger((ServerPlayer)player, data.current));
    }

    private static void giveAdvancement(OnPlayerGameStageChanged data) {
        MajruszsDifficulty.GAME_STAGE_ADVANCEMENT.trigger((ServerPlayer)data.player, data.current);
    }

    private static void giveAdvancement(OnPlayerLoggedIn data) {
        MajruszsDifficulty.GAME_STAGE_ADVANCEMENT.trigger(data.player, GameStageHelper.determineGameStage((Player)data.player));
    }

    static {
        OnGlobalGameStageChanged.listen(AdvancementProvider::giveAdvancement).addCondition(Condition.isLogicalServer()).addCondition(GameStageHelper::isPerPlayerDifficultyDisabled).addCondition(data -> data.current.getOrdinal() > data.previous.getOrdinal());
        OnPlayerGameStageChanged.listen(AdvancementProvider::giveAdvancement).addCondition(Condition.isLogicalServer()).addCondition(data -> data.current.getOrdinal() > data.previous.getOrdinal());
        OnPlayerLoggedIn.listen(AdvancementProvider::giveAdvancement).addCondition(Condition.isLogicalServer());
    }
}

