/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.collection.DefaultMap;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.registry.Registries;
import com.majruszlibrary.text.RegexString;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.gamestage.GameStageValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DoubleLoot {
    private static boolean IS_ENABLED = true;
    private static GameStageValue<Float> CHANCE = GameStageValue.of(DefaultMap.defaultEntry((Object)Float.valueOf(0.0f)), DefaultMap.entry((String)"expert", (Object)Float.valueOf(0.05f)), DefaultMap.entry((String)"master", (Object)Float.valueOf(0.1f)));
    private static List<RegexString> BLACKLISTED_ITEMS = List.of(new RegexString("minecraft:nether_star"), new RegexString("minecraft:totem_of_undying"));

    private static void doubleLoot(OnLootGenerated data) {
        if (DoubleLoot.replaceLoot((List<ItemStack>)data.generatedLoot)) {
            ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123748_).count(6).sizeBased(data.entity).emit((Level)data.getServerLevel());
        }
    }

    private static boolean replaceLoot(List<ItemStack> generatedLoot) {
        ArrayList extraLoot = new ArrayList();
        generatedLoot.forEach(itemStack -> {
            if (DoubleLoot.isAllowed(itemStack)) {
                extraLoot.add(itemStack);
            }
        });
        generatedLoot.addAll(extraLoot);
        return !extraLoot.isEmpty();
    }

    private static boolean isAllowed(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        String id = Registries.ITEMS.getId((Object)itemStack.m_41720_()).toString();
        return BLACKLISTED_ITEMS.stream().noneMatch(regex -> regex.matches(id));
    }

    static {
        OnLootGenerated.listen(DoubleLoot::doubleLoot).addCondition(data -> IS_ENABLED).addCondition(data -> data.lastDamagePlayer != null).addCondition(data -> data.entity != null).addCondition(data -> Random.check((float)CHANCE.get(GameStageHelper.determineGameStage(data)).floatValue()));
        Serializables.getStatic(Config.Features.class).define("double_loot", DoubleLoot.class);
        Serializables.getStatic(DoubleLoot.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("chance", Reader.map((IReader)Reader.number()), () -> CHANCE.get(), v -> {
            CHANCE = GameStageValue.of(Range.CHANCE.clamp(v));
        }).define("blacklisted_items", Reader.list((IReader)Reader.string()), () -> RegexString.toString(BLACKLISTED_ITEMS), v -> {
            BLACKLISTED_ITEMS = RegexString.toRegex((List)v);
        });
    }
}

