/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.collection.DefaultMap;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.OnExploded;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.entity.Creeperling;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.gamestage.GameStageValue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CreeperSplitIntoCreeperlings {
    private static boolean IS_ENABLED = true;
    private static float CHANCE = 0.666f;
    private static boolean IS_SCALED_BY_CRD = true;
    private static GameStageValue<Integer> COUNT = GameStageValue.of(DefaultMap.defaultEntry((Object)2), DefaultMap.entry((String)"expert", (Object)4), DefaultMap.entry((String)"master", (Object)6));

    private static void spawnCreeperlings(OnExploded data) {
        Creeper creeper = (Creeper)data.explosion.m_253049_();
        GameStage gameStage = GameStageHelper.determineGameStage(data);
        int count = Random.nextInt((int)1, (int)(COUNT.get(gameStage) + 1));
        for (int i = 0; i < count; ++i) {
            Creeperling creeperling = (Creeperling)EntityHelper.createSpawner(MajruszsDifficulty.CREEPERLING_ENTITY, (Level)data.getLevel()).position(AnyPos.from((BlockPos)creeper.m_20183_()).add(Random.nextVector((int)-2, (int)2, (int)-1, (int)1, (int)-2, (int)2)).center().vec3()).mobSpawnType(MobSpawnType.EVENT).spawn();
            data.skipEntityIf(entity -> entity.equals((Object)creeperling));
        }
    }

    private static void giveAdvancement(OnExploded data) {
        data.getServerLevel().m_45976_(ServerPlayer.class, new AABB(AnyPos.from((Vec3)data.position).block()).m_82377_(10.0, 6.0, 10.0)).forEach(CreeperSplitIntoCreeperlings::giveAdvancement);
    }

    private static void giveAdvancement(OnEntityDied data) {
        CreeperSplitIntoCreeperlings.giveAdvancement((ServerPlayer)data.attacker);
    }

    private static void giveAdvancement(ServerPlayer player) {
        MajruszsDifficulty.HELPER.triggerAchievement(player, "encountered_creeperling");
    }

    static {
        OnExploded.listen(CreeperSplitIntoCreeperlings::spawnCreeperlings).addCondition(Condition.isLogicalServer()).addCondition(Condition.chanceCRD(() -> Float.valueOf(CHANCE), () -> IS_SCALED_BY_CRD)).addCondition(data -> IS_ENABLED).addCondition(data -> data.explosion.m_253049_() != null).addCondition(data -> data.explosion.m_253049_().m_6095_().equals(EntityType.f_20558_));
        OnExploded.listen(CreeperSplitIntoCreeperlings::giveAdvancement).addCondition(Condition.isLogicalServer()).addCondition(data -> data.explosion.m_253049_() instanceof Creeperling);
        OnEntityDied.listen(CreeperSplitIntoCreeperlings::giveAdvancement).addCondition(data -> data.attacker instanceof ServerPlayer).addCondition(data -> data.target instanceof Creeperling);
        Serializables.getStatic(Config.Features.class).define("creeper_split_into_creeperlings", CreeperSplitIntoCreeperlings.class);
        Serializables.getStatic(CreeperSplitIntoCreeperlings.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("count", Reader.map((IReader)Reader.integer()), () -> COUNT.get(), v -> {
            COUNT = GameStageValue.of(Range.of((Number)1, (Number)20).clamp(v));
        }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
            CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), () -> IS_SCALED_BY_CRD, v -> {
            IS_SCALED_BY_CRD = v;
        });
    }
}

