/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.registry.Registries;
import com.majruszlibrary.text.RegexString;
import com.majruszsdifficulty.effects.bleeding.BleedingConfig;
import com.majruszsdifficulty.events.OnBleedingCheck;
import com.majruszsdifficulty.events.OnBleedingTooltip;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;

public class BleedingSources {

    public static class Tools {
        private static boolean IS_ENABLED = true;
        private static List<ToolDef> TOOL_DEFS = List.of(new ToolDef("minecraft:trident", 0.3f, List.of(new EnchantmentDef("minecraft:impaling", 0.04f))), new ToolDef("{regex}.*_sword", 0.3f, List.of(new EnchantmentDef("minecraft:sharpness", 0.04f), new EnchantmentDef("{regex}(minecraft:smite)|(minecraft:bane_of_arthropods)|(majruszsenchantments:misanthropy)", 0.02f))), new ToolDef("{regex}.*_axe", 0.26f, List.of(new EnchantmentDef("minecraft:sharpness", 0.04f), new EnchantmentDef("{regex}(minecraft:smite)|(minecraft:bane_of_arthropods)|(majruszsenchantments:misanthropy)", 0.02f))), new ToolDef("{regex}(.*_pickaxe)|minecraft:shears", 0.22f), new ToolDef("{regex}.*_shovel", 0.18f), new ToolDef("{regex}.*_hoe", 0.14f));

        private static void addTooltip(OnBleedingTooltip data) {
            Tools.find(data.itemStack).ifPresent(def -> data.addItem(def.getChance(data.itemStack)));
        }

        private static Optional<ToolDef> find(ItemStack itemStack) {
            return TOOL_DEFS.stream().filter(toolDef -> toolDef.matches(itemStack)).findFirst();
        }

        private static boolean toolBasedChance(OnBleedingCheck data) {
            if (data.attacker == null) {
                return false;
            }
            ItemStack itemStack = data.attacker.m_21205_();
            return Tools.find(itemStack).map(def -> Random.check((float)def.getChance(itemStack))).orElse(false);
        }

        static {
            OnBleedingCheck.listen(OnBleedingCheck::trigger).addCondition(data -> IS_ENABLED).addCondition(Tools::toolBasedChance);
            OnBleedingTooltip.listen(Tools::addTooltip).addCondition(data -> IS_ENABLED);
            Serializables.getStatic(BleedingConfig.Sources.class).define("tools", Tools.class);
            Serializables.getStatic(Tools.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
                IS_ENABLED = v;
            }).define("list", Reader.list((IReader)Reader.custom(ToolDef::new)), () -> TOOL_DEFS, v -> {
                TOOL_DEFS = v;
            });
            Serializables.get(ToolDef.class).define("id", Reader.string(), s -> s.id.get(), (s, v) -> s.id.set(v)).define("chance", Reader.number(), s -> Float.valueOf(s.chance), (s, v) -> {
                s.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            }).define("enchantments", Reader.list((IReader)Reader.custom(EnchantmentDef::new)), s -> s.enchantmentDefs, (s, v) -> {
                s.enchantmentDefs = v;
            });
            Serializables.get(EnchantmentDef.class).define("id", Reader.string(), s -> s.id.get(), (s, v) -> s.id.set(v)).define("extra_chance_per_level", Reader.number(), s -> Float.valueOf(s.chance), (s, v) -> {
                s.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            });
        }

        public static class ToolDef {
            public RegexString id;
            public float chance;
            public List<EnchantmentDef> enchantmentDefs;

            public ToolDef(String id, float chance, List<EnchantmentDef> enchantmentDefs) {
                this.id = new RegexString(id);
                this.chance = chance;
                this.enchantmentDefs = enchantmentDefs;
            }

            public ToolDef(String id, float chance) {
                this(id, chance, List.of());
            }

            public ToolDef() {
                this("", 0.0f);
            }

            public float getChance(ItemStack itemStack) {
                return this.chance + EnchantmentHelper.read((ItemStack)itemStack).enchantments.stream().map(this::getExtraChance).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
            }

            public boolean matches(ItemStack itemStack) {
                return this.id.matches(Registries.ITEMS.getId((Object)itemStack.m_41720_()).toString());
            }

            private float getExtraChance(EnchantmentHelper.EnchantmentDef itemEnchantment) {
                for (EnchantmentDef enchantmentDef : this.enchantmentDefs) {
                    if (!enchantmentDef.id.matches(itemEnchantment.id.toString())) continue;
                    return (float)itemEnchantment.level * enchantmentDef.chance;
                }
                return 0.0f;
            }
        }

        public static class EnchantmentDef {
            public RegexString id;
            public float chance;

            public EnchantmentDef(String id, float chance) {
                this.id = new RegexString(id);
                this.chance = chance;
            }

            public EnchantmentDef() {
                this("", 0.0f);
            }
        }
    }

    public static class Cactus {
        private static boolean IS_ENABLED = true;
        private static float CHANCE = 0.5f;

        static {
            OnBleedingCheck.listen(OnBleedingCheck::trigger).addCondition(Condition.chance(() -> Float.valueOf(CHANCE))).addCondition(data -> IS_ENABLED).addCondition(data -> data.source.m_276093_(DamageTypes.f_268585_));
            Serializables.getStatic(BleedingConfig.Sources.class).define("cactus", Cactus.class);
            Serializables.getStatic(Cactus.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
                IS_ENABLED = v;
            }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
                CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            });
        }
    }

    public static class Bite {
        private static boolean IS_ENABLED = true;
        private static float CHANCE = 0.5f;
        private static List<EntityType<?>> BLACKLISTED_ANIMALS = List.of(EntityType.f_20466_);

        static {
            OnBleedingCheck.listen(OnBleedingCheck::trigger).addCondition(Condition.chance(() -> Float.valueOf(CHANCE))).addCondition(data -> IS_ENABLED).addCondition(data -> !data.source.m_269014_()).addCondition(data -> data.attacker instanceof Animal || data.attacker instanceof Zombie || data.attacker instanceof Spider).addCondition(data -> !BLACKLISTED_ANIMALS.contains(data.attacker.m_6095_()));
            Serializables.getStatic(BleedingConfig.Sources.class).define("bite", Bite.class);
            Serializables.getStatic(Bite.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
                IS_ENABLED = v;
            }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
                CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            }).define("blacklisted_animals", Reader.list((IReader)Reader.entityType()), () -> BLACKLISTED_ANIMALS, v -> {
                BLACKLISTED_ANIMALS = v;
            });
        }
    }

    public static class Arrows {
        private static boolean IS_ENABLED = true;
        private static float CHANCE = 0.333f;

        private static void addTooltip(OnBleedingTooltip data) {
            data.addItem(CHANCE);
        }

        static {
            OnBleedingCheck.listen(OnBleedingCheck::trigger).addCondition(Condition.chance(() -> Float.valueOf(CHANCE))).addCondition(data -> IS_ENABLED).addCondition(data -> data.source.m_7640_() instanceof Arrow);
            OnBleedingTooltip.listen(Arrows::addTooltip).addCondition(data -> IS_ENABLED).addCondition(data -> data.itemStack.m_41720_() instanceof ProjectileWeaponItem);
            Serializables.getStatic(BleedingConfig.Sources.class).define("arrows", Arrows.class);
            Serializables.getStatic(Arrows.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
                IS_ENABLED = v;
            }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
                CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            });
        }
    }
}

