/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.flac;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import vminus.shadow.org.gagravarr.flac.FlacAudioFrame;
import vminus.shadow.org.gagravarr.flac.FlacFile;
import vminus.shadow.org.gagravarr.flac.FlacFirstOggPacket;
import vminus.shadow.org.gagravarr.flac.FlacMetadataBlock;
import vminus.shadow.org.gagravarr.flac.FlacOggInfo;
import vminus.shadow.org.gagravarr.flac.FlacTags;
import vminus.shadow.org.gagravarr.ogg.OggFile;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.ogg.OggPacketReader;
import vminus.shadow.org.gagravarr.ogg.OggPacketWriter;
import vminus.shadow.org.gagravarr.ogg.OggStreamIdentifier;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioHeaders;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioSetupHeader;

public class FlacOggFile
extends FlacFile
implements OggAudioHeaders {
    private OggFile ogg;
    private OggPacketReader r;
    private OggPacketWriter w;
    private int sid = -1;
    private FlacFirstOggPacket firstPacket;
    private List<FlacAudioFrame> writtenAudio;

    public FlacOggFile(File f) throws IOException, FileNotFoundException {
        this(new OggFile(new FileInputStream(f)));
    }

    public FlacOggFile(OggFile ogg) throws IOException {
        this(ogg.getPacketReader());
        this.ogg = ogg;
    }

    public FlacOggFile(OggPacketReader r) throws IOException {
        this.r = r;
        OggPacket p = null;
        while ((p = r.getNextPacket()) != null) {
            if (!p.isBeginningOfStream() || p.getData().length <= 10 || !FlacFirstOggPacket.isFlacStream(p)) continue;
            this.sid = p.getSid();
            break;
        }
        this.firstPacket = new FlacFirstOggPacket(p);
        this.info = this.firstPacket.getInfo();
        this.tags = new FlacTags(r.getNextPacketWithSid(this.sid));
        this.otherMetadata = new ArrayList();
        while ((p = r.getNextPacketWithSid(this.sid)) != null) {
            FlacMetadataBlock block = FlacMetadataBlock.create(new ByteArrayInputStream(p.getData()));
            this.otherMetadata.add(block);
            if (!block.isLastMetadataBlock()) continue;
            break;
        }
    }

    public FlacOggFile(OutputStream out) {
        this(out, new FlacOggInfo(), new FlacTags());
    }

    public FlacOggFile(OutputStream out, FlacOggInfo info, FlacTags tags) {
        this(out, -1, info, tags);
    }

    public FlacOggFile(OutputStream out, int sid, FlacOggInfo info, FlacTags tags) {
        this.ogg = new OggFile(out);
        if (sid > 0) {
            this.w = this.ogg.getPacketWriter(sid);
            this.sid = sid;
        } else {
            this.w = this.ogg.getPacketWriter();
            this.sid = this.w.getSid();
        }
        this.writtenAudio = new ArrayList<FlacAudioFrame>();
        this.firstPacket = new FlacFirstOggPacket(info);
        this.info = info;
        this.tags = tags;
    }

    public FlacFirstOggPacket getFirstPacket() {
        return this.firstPacket;
    }

    public FlacAudioFrame getNextAudioPacket() throws IOException {
        OggPacket p = null;
        p = this.r.getNextPacketWithSid(this.sid);
        if (p != null) {
            return new FlacAudioFrame(p.getData(), this.info);
        }
        return null;
    }

    public void skipToGranule(long granulePosition) throws IOException {
        this.r.skipToGranulePosition(this.sid, granulePosition);
    }

    public int getSid() {
        return this.sid;
    }

    public OggStreamIdentifier.OggStreamType getType() {
        return OggStreamIdentifier.OGG_FLAC;
    }

    public void writeAudioData(FlacAudioFrame data) {
        this.writtenAudio.add(data);
    }

    public void close() throws IOException {
        if (this.r != null) {
            this.r = null;
            this.ogg.close();
            this.ogg = null;
        }
        if (this.w != null) {
            this.w.bufferPacket(this.firstPacket.write(), true);
            this.w.bufferPacket(this.tags.write(), false);
            long lastGranule = 0L;
            for (FlacAudioFrame fa : this.writtenAudio) {
                this.w.bufferPacket(new OggPacket(fa.getData()));
                if (this.w.getSizePendingFlush() <= 16384) continue;
                this.w.flush();
            }
            this.w.close();
            this.w = null;
            this.ogg.close();
            this.ogg = null;
        }
    }

    public FlacOggInfo getInfo() {
        return (FlacOggInfo)this.info;
    }

    public OggAudioSetupHeader getSetup() {
        return null;
    }

    public OggFile getOggFile() {
        return this.ogg;
    }
}

