/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.flac;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import vminus.shadow.org.gagravarr.flac.FlacAudioFrame;
import vminus.shadow.org.gagravarr.flac.FlacInfo;
import vminus.shadow.org.gagravarr.flac.FlacMetadataBlock;
import vminus.shadow.org.gagravarr.flac.FlacNativeFile;
import vminus.shadow.org.gagravarr.flac.FlacOggFile;
import vminus.shadow.org.gagravarr.flac.FlacTags;
import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggFile;

public abstract class FlacFile
implements Closeable {
    protected FlacInfo info;
    protected FlacTags tags;
    protected List<FlacMetadataBlock> otherMetadata;

    public static FlacFile open(File f) throws IOException, FileNotFoundException {
        BufferedInputStream inp = new BufferedInputStream(new FileInputStream(f), 8);
        FlacFile file = FlacFile.open(inp);
        return file;
    }

    public static FlacFile open(InputStream inp) throws IOException, FileNotFoundException {
        inp.mark(4);
        byte[] header = new byte[4];
        IOUtils.readFully(inp, header);
        inp.reset();
        if (header[0] == 79 && header[1] == 103 && header[2] == 103 && header[3] == 83) {
            return new FlacOggFile(new OggFile(inp));
        }
        if (header[0] == 102 && header[1] == 76 && header[2] == 97 && header[3] == 67) {
            return new FlacNativeFile(inp);
        }
        throw new IllegalArgumentException("File type not recognised");
    }

    public static FlacFile open(OggFile ogg) throws IOException {
        return new FlacOggFile(ogg);
    }

    public abstract FlacAudioFrame getNextAudioPacket() throws IOException;

    public abstract void skipToGranule(long var1) throws IOException;

    public FlacInfo getInfo() {
        return this.info;
    }

    public FlacTags getTags() {
        return this.tags;
    }

    public abstract void close() throws IOException;
}

