/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision.values.conditions;

import net.lixir.vminus.vision.values.conditions.AbstractVisionCondition;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;

public class EntityStringNbtVisionCondition
extends AbstractVisionCondition {
    private final String path;
    private final String value;

    public EntityStringNbtVisionCondition(String path, String value, boolean inverted) {
        super(inverted);
        this.path = path;
        this.value = value;
    }

    @Override
    public boolean test(VisionContext visionContext) {
        if (visionContext.hasEntity()) {
            Entity entity = visionContext.getEntity();
            assert (entity != null);
            CompoundTag nbt = entity.getPersistentData();
            Tag tag = this.getTagFromPath(nbt, this.path.split("/"));
            return tag != null && tag.m_7916_().equals(this.value);
        }
        return true;
    }

    private Tag getTagFromPath(CompoundTag nbt, String[] path) {
        CompoundTag current = nbt;
        for (String key : path) {
            if (!(current instanceof CompoundTag)) {
                return null;
            }
            CompoundTag compound = current;
            current = compound.m_128423_(key);
            if (current != null) continue;
            return null;
        }
        return current;
    }
}

