/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lixir.vminus.resources.data.vision.codec.VisionCodecs;
import net.lixir.vminus.vision.VisionProperty;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.lixir.vminus.vision.util.BaseAttribute;
import net.lixir.vminus.vision.util.CreativeOrder;
import net.lixir.vminus.vision.util.ItemReplacement;
import net.lixir.vminus.vision.util.ItemStackWrapper;
import net.lixir.vminus.vision.util.VisionAttribute;
import net.lixir.vminus.vision.util.VisionEntityVariant;
import net.lixir.vminus.vision.util.VisionFoodProperties;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class VisionProperties {
    private static final Map<VisionType<?>, List<VisionProperty<?>>> REGISTRY = new HashMap();
    private static final Map<Key, VisionProperty<?>> PROPERTY_BY_ID = new HashMap();

    public static void init() {
        Class[] classes;
        for (Class clazz : classes = new Class[]{Items.class, Effects.class, Tabs.class, Entities.class, Blocks.class}) {
            try {
                Class.forName(clazz.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to load VisionPropertyTypes nested class: " + clazz.getName(), e);
            }
        }
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static <T, V> VisionProperty<V> register(@NotNull VisionType<T> visionType, VisionProperty<V> property) {
        REGISTRY.computeIfAbsent(visionType, c -> new ArrayList()).add(property);
        PROPERTY_BY_ID.put(new Key(visionType, property.getId()), property);
        return property;
    }

    public static <T> VisionProperty<T> get(VisionType<T> visionType, String id) {
        return PROPERTY_BY_ID.get(new Key(visionType, id));
    }

    public static @UnmodifiableView @NotNull List<VisionProperty<?>> fromVisionType(VisionType<?> visionType) {
        List list = REGISTRY.getOrDefault(visionType, List.of());
        return Collections.unmodifiableList(list);
    }

    @Contract(value="_ -> param1")
    @NotNull
    public static <V> VisionProperty<V> itemProperty(VisionProperty<V> property) {
        return VisionProperties.register(VisionTypes.ITEM, property);
    }

    @Contract(value="_ -> param1")
    @NotNull
    public static <V> VisionProperty<V> blockProperty(VisionProperty<V> property) {
        return VisionProperties.register(VisionTypes.BLOCK, property);
    }

    @Contract(value="_ -> param1")
    @NotNull
    public static <V> VisionProperty<V> entityProperty(VisionProperty<V> property) {
        return VisionProperties.register(VisionTypes.ENTITY, property);
    }

    @Contract(value="_ -> param1")
    @NotNull
    public static <V> VisionProperty<V> effectProperty(VisionProperty<V> property) {
        return VisionProperties.register(VisionTypes.EFFECT, property);
    }

    @Contract(value="_ -> param1")
    @NotNull
    public static <V> VisionProperty<V> tabProperty(VisionProperty<V> property) {
        return VisionProperties.register(VisionTypes.TAB, property);
    }

    public static class Items {
        public static final VisionProperty<VisionFoodProperties> FOOD = VisionProperties.itemProperty(VisionProperty.create("food", VisionCodecs.FOOD_PROPERTIES));
        public static final VisionProperty<SoundEvent> COLLECT_SOUND = VisionProperties.itemProperty(VisionProperty.create("collect_sound", VisionCodecs.SOUND_EVENT));
        public static final VisionProperty<UseAnim> USE_ANIMATION = VisionProperties.itemProperty(VisionProperty.create("use_animation", VisionCodecs.USE_ANIMATION));
        public static final VisionProperty<Integer> MAX_DAMAGE = VisionProperties.itemProperty(VisionProperty.create("max_damage", VisionCodecs.INTEGER));
        public static final VisionProperty<Integer> MAX_STACK_SIZE = VisionProperties.itemProperty(VisionProperty.create("max_stack_size", VisionCodecs.INTEGER));
        public static final VisionProperty<Integer> USE_TICKS = VisionProperties.itemProperty(VisionProperty.create("use_ticks", VisionCodecs.INTEGER));
        public static final VisionProperty<Integer> MAX_USE_TICKS = VisionProperties.itemProperty(VisionProperty.create("max_use_ticks", VisionCodecs.INTEGER));
        public static final VisionProperty<Integer> FUEL_TICKS = VisionProperties.itemProperty(VisionProperty.create("fuel_ticks", VisionCodecs.INTEGER));
        public static final VisionProperty<Integer> ENCHANTABILITY = VisionProperties.itemProperty(VisionProperty.create("enchantability", VisionCodecs.INTEGER));
        public static final VisionProperty<Boolean> GLINT = VisionProperties.itemProperty(VisionProperty.create("glint", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Boolean> ENCHANTABLE = VisionProperties.itemProperty(VisionProperty.create("enchantable", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Boolean> FIRE_RESISTANT = VisionProperties.itemProperty(VisionProperty.create("fire_resistant", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Boolean> CAN_EQUIP = VisionProperties.itemProperty(VisionProperty.create("can_equip", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Boolean> BAN = VisionProperties.itemProperty(VisionProperty.create("ban", VisionCodecs.BOOLEAN));
        public static final VisionProperty<ItemStackWrapper> USE_REMAINDER = VisionProperties.itemProperty(VisionProperty.create("use_remainder", VisionCodecs.ITEM_STACK));
        public static final VisionProperty<ItemReplacement> REPLACE = VisionProperties.itemProperty(VisionProperty.create("replace", VisionCodecs.ITEM_REPLACEMENT));
        public static final VisionProperty<EquipmentSlot> EQUIP_SLOT = VisionProperties.itemProperty(VisionProperty.create("equip_slot", VisionCodecs.EQUIP_SLOT));
        public static final VisionProperty<Rarity> RARITY = VisionProperties.itemProperty(VisionProperty.create("rarity", VisionCodecs.RARITY));
        public static final VisionProperty<VisionAttribute> ATTRIBUTE = VisionProperties.itemProperty(VisionProperty.create("attribute", VisionCodecs.ATTRIBUTE));
    }

    public static class Effects {
        public static final VisionProperty<MobEffectCategory> CATEGORY = VisionProperties.effectProperty(VisionProperty.create("category", VisionCodecs.EFFECT_CATEGORY));
        public static final VisionProperty<Integer> COLOR = VisionProperties.effectProperty(VisionProperty.create("color", VisionCodecs.HEX));
        public static final VisionProperty<Boolean> BAN = VisionProperties.effectProperty(VisionProperty.create("ban", VisionCodecs.BOOLEAN));
    }

    public static class Tabs {
        public static final VisionProperty<ItemStackWrapper> ICON = VisionProperties.tabProperty(VisionProperty.create("icon", VisionCodecs.ITEM_STACK));
        public static final VisionProperty<Boolean> HIDE = VisionProperties.tabProperty(VisionProperty.create("hide", VisionCodecs.BOOLEAN));
        public static final VisionProperty<CreativeOrder> ORDER = VisionProperties.tabProperty(VisionProperty.create("order", VisionCodecs.CREATIVE_ORDER));
        public static final VisionProperty<ItemReplacement> REMOVE = VisionProperties.tabProperty(VisionProperty.create("remove", VisionCodecs.ITEM_REPLACEMENT));
    }

    public static class Entities {
        public static final VisionProperty<VisionEntityVariant> VARIANT = VisionProperties.entityProperty(VisionProperty.create("variant", VisionCodecs.ENTITY_VARIANT));
        public static final VisionProperty<Boolean> BAN = VisionProperties.entityProperty(VisionProperty.create("ban", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Boolean> SILENT = VisionProperties.entityProperty(VisionProperty.create("silent", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Boolean> DAMPENS_VIBRATION = VisionProperties.entityProperty(VisionProperty.create("dampens_vibration", VisionCodecs.BOOLEAN));
        public static final VisionProperty<BaseAttribute> BASE_ATTRIBUTE = VisionProperties.entityProperty(VisionProperty.create("base_attribute", VisionCodecs.BASE_ATTRIBUTE, false));
    }

    public static class Blocks {
        public static final VisionProperty<Float> SPEED_FACTOR = VisionProperties.blockProperty(VisionProperty.create("speed_factor", VisionCodecs.FLOAT));
        public static final VisionProperty<Float> JUMP_FACTOR = VisionProperties.blockProperty(VisionProperty.create("jump_factor", VisionCodecs.FLOAT));
        public static final VisionProperty<Float> BLAST_RESISTANCE = VisionProperties.blockProperty(VisionProperty.create("blast_resistance", VisionCodecs.FLOAT));
        public static final VisionProperty<Float> BREAK_SPEED = VisionProperties.blockProperty(VisionProperty.create("break_speed", VisionCodecs.FLOAT));
        public static final VisionProperty<Float> FRICTION = VisionProperties.blockProperty(VisionProperty.create("friction", VisionCodecs.FLOAT));
        public static final VisionProperty<Boolean> BAN = VisionProperties.blockProperty(VisionProperty.create("ban", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Block> REPLACE = VisionProperties.blockProperty(VisionProperty.create("replace", VisionCodecs.BLOCK));
        public static final VisionProperty<Boolean> EMISSIVE = VisionProperties.blockProperty(VisionProperty.create("emissive", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Boolean> OCCLUDE = VisionProperties.blockProperty(VisionProperty.create("occlude", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Boolean> REDSTONE_CONDUCTOR = VisionProperties.blockProperty(VisionProperty.create("redstone_conductor", VisionCodecs.BOOLEAN));
        public static final VisionProperty<Integer> LIGHT_LEVEL = VisionProperties.blockProperty(VisionProperty.create("light_level", VisionCodecs.INTEGER));
        public static final VisionProperty<SoundType> SOUND = VisionProperties.blockProperty(VisionProperty.create("sound", VisionCodecs.SOUND_TYPE));
    }

    private record Key(VisionType<?> type, String id) {
    }
}

