/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class VisionEntry<T> {
    private final List<String> entries = new ArrayList<String>();
    private final HashMap<String, List<? extends VisionValue<?>>> values = new HashMap();

    public boolean isEmpty() {
        return this.entries.isEmpty() || this.values.isEmpty();
    }

    public static boolean visionApplies(@Nullable Object object, @NotNull String id, @NotNull List<String> applicantList, @Nullable ICondition.IContext context) {
        boolean invalidMatch = false;
        boolean validMatchFound = false;
        String[] idParts = id.split(":", 2);
        String idPath = idParts.length > 1 ? idParts[1] : idParts[0];
        for (String rawMatchKey : applicantList) {
            EntityType entityType;
            Block block;
            Item item;
            boolean found;
            String[] matchParts;
            boolean inverted = rawMatchKey.startsWith("!");
            String matchKey = inverted ? rawMatchKey.substring(1) : rawMatchKey;
            boolean isTag = matchKey.startsWith("#");
            if (isTag) {
                matchKey = matchKey.substring(1);
            }
            String matchNamespace = (matchParts = matchKey.split(":", 2)).length > 1 ? matchParts[0] : "";
            String matchPath = matchParts.length > 1 ? matchParts[1] : matchParts[0];
            boolean bl = found = matchKey.equals("all") || VisionEntry.wildcardMatches(id, matchKey) || matchNamespace.isEmpty() && (idPath.equals(matchPath) || VisionEntry.wildcardMatches(idPath, matchPath)) || !isTag && (id.equals(matchKey) || VisionEntry.wildcardMatches(id, matchKey)) || isTag && (object instanceof Item && VisionEntry.isItemTagged(item = (Item)object, new ResourceLocation(matchKey), context) || object instanceof Block && VisionEntry.isBlockTagged(block = (Block)object, new ResourceLocation(matchKey), context) || object instanceof EntityType && VisionEntry.isEntityTagged(entityType = (EntityType)object, new ResourceLocation(matchKey), context));
            if (inverted) {
                boolean bl2 = found = !found;
            }
            if (!inverted && found) {
                validMatchFound = true;
                continue;
            }
            if (!inverted || found) continue;
            invalidMatch = true;
            break;
        }
        return !invalidMatch && validMatchFound;
    }

    private static boolean isItemTagged(Item item, ResourceLocation matchKey, @Nullable ICondition.IContext context) {
        return VisionEntry.isTagged(item, matchKey, context, ForgeRegistries.ITEMS, key -> TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)key));
    }

    private static boolean isBlockTagged(Block block, ResourceLocation matchKey, @Nullable ICondition.IContext context) {
        return VisionEntry.isTagged(block, matchKey, context, ForgeRegistries.BLOCKS, key -> TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)key));
    }

    private static boolean isEntityTagged(EntityType<?> entityType, ResourceLocation matchKey, @Nullable ICondition.IContext context) {
        return VisionEntry.isTagged(entityType, matchKey, context, ForgeRegistries.ENTITY_TYPES, key -> TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)key));
    }

    private static <T> boolean isTagged(T object, ResourceLocation matchKey, ICondition.IContext context, IForgeRegistry<T> registry, Function<ResourceLocation, TagKey<T>> tagKeyFactory) {
        if (context == null) {
            return false;
        }
        TagKey<T> tagKey = tagKeyFactory.apply(matchKey);
        Collection tags = context.getTag(tagKey);
        if (tags == null || tags.isEmpty()) {
            return false;
        }
        ResourceLocation objectKey = registry.getKey(object);
        if (objectKey == null) {
            return false;
        }
        return tags.stream().anyMatch(holder -> Objects.equals(registry.getKey(holder.m_203334_()), objectKey));
    }

    private static boolean wildcardMatches(String value, @NotNull String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.startsWith("*")) {
            if (pattern.endsWith("*")) {
                return value.contains(pattern.substring(1, pattern.length() - 1));
            }
            return value.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return value.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return value.equals(pattern);
    }

    public HashMap<String, List<? extends VisionValue<?>>> getValues() {
        return this.values;
    }

    public List<String> getEntries() {
        return this.entries;
    }

    public void addValues(String key, List<? extends VisionValue<?>> values) {
        this.values.merge(key, new ArrayList(values), (existingList, newList) -> {
            ArrayList combined = new ArrayList(existingList);
            combined.addAll(newList);
            return combined;
        });
    }

    public void addEntries(ArrayList<String> newEntries) {
        this.entries.addAll(newEntries);
    }

    public void merge(@NotNull VisionEntry<T> visionEntry) {
        this.entries.addAll(visionEntry.getEntries());
        for (Map.Entry<String, List<VisionValue<?>>> entry : visionEntry.values.entrySet()) {
            String key = entry.getKey();
            List<? extends VisionValue<?>> incomingValues = entry.getValue();
            this.values.merge(key, new ArrayList(incomingValues), (existingList, newList) -> {
                ArrayList combined = new ArrayList(existingList);
                combined.addAll(newList);
                return combined;
            });
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VisionEntry");
        sb.append("  entries = ").append(this.entries).append(",\n");
        sb.append("  values = {\n");
        for (Map.Entry<String, List<VisionValue<?>>> entry : this.values.entrySet()) {
            sb.append("    ").append(entry.getKey()).append(" = ");
            sb.append(entry.getValue()).append(",\n");
        }
        sb.append("  }\n");
        sb.append("}");
        return sb.toString();
    }
}

